/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class PlaceholderUtils {
    public static final Pattern PATTERN_BRACE = Pattern.compile("\\$\\{(.*?)}");
    public static final Pattern PATTERN_ANGLE = Pattern.compile("\\$<(.*?)>");
    private static Matcher matcher;

    public static String replaceWithVarargs(String source, Object ... params) {
        return MessageFormat.format(source, params);
    }

    public static String replaceWithMap(String source, Map<String, Object> params) {
        if (StringUtils.isBlank((CharSequence)source) || CollectionUtils.isEmpty(params)) {
            return source;
        }
        String targetString = source;
        matcher = PATTERN_BRACE.matcher(source);
        while (matcher.find()) {
            try {
                String key = matcher.group();
                String keyClone = key.substring(2, key.length() - 1).trim();
                Object value = params.get(keyClone);
                if (value == null) continue;
                targetString = targetString.replace(key, value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("\u5b57\u7b26\u4e32\u683c\u5f0f\u5316\u7a0b\u5e8f\u5931\u8d25", e);
            }
        }
        return targetString;
    }

    public static String replaceWithObject(String source, Object params) {
        if (StringUtils.isBlank((CharSequence)source) || ObjectUtils.isEmpty((Object)params)) {
            return source;
        }
        String targetString = source;
        matcher = PATTERN_BRACE.matcher(source);
        while (matcher.find()) {
            String key = matcher.group();
            String holderName = key.substring(2, key.length() - 1).trim();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(holderName, params.getClass());
                Method getMethod = pd.getReadMethod();
                Object value = getMethod.invoke(params, new Object[0]);
                if (value == null) continue;
                targetString = targetString.replace(key, value.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("\u5b57\u7b26\u4e32\u683c\u5f0f\u5316\u7a0b\u5e8f\u5931\u8d25", e);
            }
        }
        return targetString;
    }

    public static Set<String> getPlaceholderKeys(String source, Pattern pattern) {
        HashSet<String> placeHolderSet = new HashSet<String>();
        if (StringUtils.isBlank((CharSequence)source) || ObjectUtils.isEmpty((Object)pattern)) {
            return placeHolderSet;
        }
        matcher = pattern.matcher(source);
        while (matcher.find()) {
            String key = matcher.group();
            String placeHolder = key.substring(2, key.length() - 1).trim();
            placeHolderSet.add(placeHolder);
        }
        return placeHolderSet;
    }

    public static void main(String[] args) {
        System.out.println(PlaceholderUtils.replaceWithVarargs("%{0}%", "likeName"));
    }
}

