/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util.cps;

import com.thebeastshop.op.constant.cps.CpsCategoryType;
import com.thebeastshop.op.constant.cps.CpsCommissionType;
import java.math.BigDecimal;

public class CpsOrderUtil {
    public static BigDecimal calculateCommission(BigDecimal totalPrice, CpsCommissionType commissionType) {
        return totalPrice.multiply(commissionType.getCommissionRate()).setScale(2, 3);
    }

    public static CpsCommissionType calculateCommissionRate(CpsCategoryType cpsCategoryType, BigDecimal totalPrice, int count) {
        if ((CpsCategoryType.FLOWER.equals((Object)cpsCategoryType) || CpsCategoryType.HOME_DECORATION.equals((Object)cpsCategoryType)) && count > 0 && totalPrice.divide(BigDecimal.valueOf(count), 2, 3).compareTo(BigDecimal.valueOf(1500L)) >= 0) {
            return CpsCommissionType.TYPE_1;
        }
        return cpsCategoryType.getCommissionType();
    }

    public static CpsCategoryType convertToCpsCategoryType(String categoryCode) {
        CpsCategoryType categoryType = null;
        categoryType = "1".equalsIgnoreCase(categoryCode) ? CpsCategoryType.FLOWER : ("fr".equalsIgnoreCase(categoryCode) ? CpsCategoryType.FLOWER : ("2".equalsIgnoreCase(categoryCode) ? CpsCategoryType.JEWELRY : ("jw".equalsIgnoreCase(categoryCode) ? CpsCategoryType.JEWELRY : ("lg".equalsIgnoreCase(categoryCode) ? CpsCategoryType.JEWELRY : ("3".equalsIgnoreCase(categoryCode) ? CpsCategoryType.PERSONAL_CARE : ("pc".equalsIgnoreCase(categoryCode) ? CpsCategoryType.PERSONAL_CARE : ("frag".equalsIgnoreCase(categoryCode) ? CpsCategoryType.PERSONAL_CARE : ("11".equals(categoryCode) ? CpsCategoryType.PERSONAL_CARE : ("4".equals(categoryCode) ? CpsCategoryType.HOME_DECORATION : ("ht".equalsIgnoreCase(categoryCode) ? CpsCategoryType.HOME_DECORATION : ("12".equals(categoryCode) ? CpsCategoryType.HOME_DECORATION : ("7".equalsIgnoreCase(categoryCode) ? CpsCategoryType.HOME_DECORATION : ("hd".equalsIgnoreCase(categoryCode) ? CpsCategoryType.HOME_DECORATION : ("5".equalsIgnoreCase(categoryCode) ? CpsCategoryType.LIVING_ROOM_AND_WORK : ("6".equalsIgnoreCase(categoryCode) ? CpsCategoryType.KITCHEN_AND_FOOD : ("tt".equalsIgnoreCase(categoryCode) ? CpsCategoryType.KITCHEN_AND_FOOD : ("8".equalsIgnoreCase(categoryCode) ? CpsCategoryType.CHILDREN_AND_PET : ("9".equalsIgnoreCase(categoryCode) ? CpsCategoryType.PACKAGE_AND_ACCESSORY : CpsCategoryType.LIVING_ROOM_AND_WORK))))))))))))))))));
        return categoryType;
    }

    public static int linkTechConvertToCpsCategoryType(BigDecimal actualUnitPrice, String categoryCode) {
        CpsCategoryType cpsCategoryType = CpsOrderUtil.convertToCpsCategoryType(categoryCode);
        if ((CpsCategoryType.FLOWER.equals((Object)cpsCategoryType) || CpsCategoryType.HOME_DECORATION.equals((Object)cpsCategoryType)) && actualUnitPrice.compareTo(BigDecimal.valueOf(1500L)) >= 0) {
            return 10;
        }
        return cpsCategoryType.getCategoryCode();
    }
}

