/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.vo.expectStock;

import com.thebeastshop.op.vo.expectStock.OpPackageSkuExpectStockVO;
import java.io.Serializable;
import java.util.Objects;

public class ExpectStockType
implements Serializable {
    private final Integer stockExpectType;
    private final Integer minExpectPeriod;
    private final Integer forceExpectedPeriod;

    public ExpectStockType(Integer stockExpectType, Integer minExpectPeriod, Integer forceExpectedPeriod) {
        this.stockExpectType = stockExpectType;
        this.minExpectPeriod = minExpectPeriod == null ? -1 : minExpectPeriod;
        this.forceExpectedPeriod = forceExpectedPeriod;
    }

    public static ExpectStockType buildFrom(OpPackageSkuExpectStockVO data) {
        return new ExpectStockType(data.getStockExpectType(), data.getMinExpectPeriod(), data.getForceExpectedPeriod());
    }

    public Integer getStockExpectType() {
        return this.stockExpectType;
    }

    public Integer getMinExpectPeriod() {
        return this.minExpectPeriod;
    }

    public Integer getForceExpectedPeriod() {
        return this.forceExpectedPeriod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpectStockType that = (ExpectStockType)o;
        return Objects.equals(this.stockExpectType, that.stockExpectType) && Objects.equals(this.minExpectPeriod, that.minExpectPeriod) && Objects.equals(this.forceExpectedPeriod, that.forceExpectedPeriod);
    }

    public int hashCode() {
        return Objects.hash(this.stockExpectType, this.minExpectPeriod, this.forceExpectedPeriod);
    }
}

