/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.api.ApiException;
import com.taobao.api.FileItem;
import com.taobao.api.response.RefundMessageAddResponse;
import com.taobao.api.response.RefundMessagesGetResponse;
import com.taobao.api.response.RefundRefuseResponse;
import com.taobao.api.response.RpRefundReviewResponse;
import com.taobao.api.response.RpReturngoodsAgreeResponse;
import com.taobao.api.response.RpReturngoodsRefillResponse;
import com.taobao.api.response.RpReturngoodsRefuseResponse;
import com.taobao.api.response.TradeGetResponse;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.tmall.dto.RefundMessageAddRequestDTO;
import com.thebeastshop.tmall.dto.RefundMessagesGetRequestDTO;
import com.thebeastshop.tmall.dto.RefundRefuseRequestDTO;
import com.thebeastshop.tmall.dto.RpRefundReviewRequestDTO;
import com.thebeastshop.tmall.dto.RpReturngoodsAgreeRequestDTO;
import com.thebeastshop.tmall.dto.RpReturngoodsRefillRequestDTO;
import com.thebeastshop.tmall.dto.RpReturngoodsRefuseRequestDTO;
import com.thebeastshop.tmall.dto.TradeGetRequestDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class TaobaoRefundInterfaceInvokeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaobaoRefundInterfaceInvokeUtil.class);
    private static final String tmallJushitaReadUrl = "http://121.89.195.0";
    @Value(value="${tmall.jushita.url}")
    private String tmallJushitaUrl;
    @Autowired
    private RestTemplate restTemplate;

    public Boolean taoBaoRefundMessageAdd(Long refundId, String content, String fileName, byte[] image, String channelCode) throws ApiException {
        RefundMessageAddRequestDTO req = new RefundMessageAddRequestDTO();
        req.setRefundId(refundId);
        req.setContent(content);
        req.setImage(new FileItem(fileName, image));
        req.setChannelCode(channelCode);
        RefundMessageAddResponse rsp = (RefundMessageAddResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taoBaoRefundMessageAdd", (Object)req, RefundMessageAddResponse.class, new Object[0]).getBody();
        LOGGER.info(rsp.toString());
        if (null != JSON.parseObject((String)rsp.getBody()).getJSONObject("refund_message_add_response")) {
            return true;
        }
        throw new BusinessException("999999", rsp.getBody() + "   \u5929\u732b\u9000\u6b3e\u5355\u53f7\uff1a" + refundId);
    }

    public Boolean taoBaoRefundRefuse(Long refundId, String refuseMessage, String fileName, byte[] refuseProof, Long refuseReasonId, String channelCode) throws Exception {
        RefundRefuseRequestDTO req = new RefundRefuseRequestDTO();
        req.setRefundId(refundId);
        req.setRefuseMessage(refuseMessage);
        req.setRefuseProof(new RefundRefuseRequestDTO.FileItem(fileName, refuseProof));
        req.setRefuseReasonId(refuseReasonId);
        req.setChannelCode(channelCode);
        RefundRefuseResponse rsp = (RefundRefuseResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taoBaoRefundRefuse", (Object)req, RefundRefuseResponse.class, new Object[0]).getBody();
        LOGGER.info(rsp.toString());
        if (null != JSON.parseObject((String)rsp.getBody()).getJSONObject("refund_refuse_response")) {
            return true;
        }
        throw new BusinessException("999999", rsp.getBody() + "   \u5929\u732b\u9000\u6b3e\u5355\u53f7\uff1a" + refundId);
    }

    public Boolean taoBaoRefundAgree(String code, String refundInfos, String channelCode) throws ApiException {
        return true;
    }

    public Boolean taoBaoRefundGoodsAgree(Long refundId, String name, String address, String post, String tel, String mobile, String remark, Long sellerAddressId, Integer postFeeBearRole, String channelCode) throws ApiException {
        RpReturngoodsAgreeRequestDTO req = new RpReturngoodsAgreeRequestDTO();
        req.setRefundId(refundId);
        req.setName(name);
        req.setAddress(address);
        req.setPost(post);
        req.setTel(tel);
        req.setMobile(mobile);
        req.setRemark("SCM\u64cd\u4f5c\u540c\u610f\u9000\u8d27");
        req.setSellerAddressId(Long.valueOf(759840522L));
        req.setChannelCode(channelCode);
        RpReturngoodsAgreeResponse rsp = (RpReturngoodsAgreeResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taoBaoRefundAgree", (Object)req, RpReturngoodsAgreeResponse.class, new Object[0]).getBody();
        LOGGER.info(rsp.toString());
        if (null != JSON.parseObject((String)rsp.getBody()).getJSONObject("rp_returngoods_agree_response")) {
            return true;
        }
        throw new BusinessException("999999", rsp.getBody() + "   \u5929\u732b\u9000\u6b3e\u5355\u53f7\uff1a" + refundId);
    }

    public Boolean taoBaoRefundReview(Long refundId, String operator, Boolean result, String message, String channelCode) throws ApiException {
        RpRefundReviewRequestDTO req = new RpRefundReviewRequestDTO();
        req.setRefundId(refundId);
        req.setOperator("thebeast\u91ce\u517d\u6d3e\u5b98\u65b9\u65d7\u8230\u5e97:\u897f\u4f2f\u5229\u4e9a\u72fc");
        req.setResult(result);
        req.setMessage(message);
        req.setChannelCode(channelCode);
        RpRefundReviewResponse rsp = (RpRefundReviewResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taoBaoRefundReview", (Object)req, RpRefundReviewResponse.class, new Object[0]).getBody();
        LOGGER.info(rsp.toString());
        if (null != JSON.parseObject((String)rsp.getBody()).getJSONObject("rp_refund_review_response")) {
            return true;
        }
        throw new BusinessException("999999", rsp.getBody() + "   \u5929\u732b\u9000\u6b3e\u5355\u53f7\uff1a" + refundId);
    }

    public Boolean taoBaoReturnGoodsRefill(Long refundId, String logisticsWaybillNo, String logisticsCompanyCode, String channelCode) throws ApiException {
        RpReturngoodsRefillRequestDTO req = new RpReturngoodsRefillRequestDTO();
        req.setRefundId(refundId);
        req.setLogisticsWaybillNo(logisticsWaybillNo);
        req.setLogisticsCompanyCode(logisticsCompanyCode);
        req.setChannelCode(channelCode);
        RpReturngoodsRefillResponse rsp = (RpReturngoodsRefillResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taoBaoReturnGoodsRefill", (Object)req, RpReturngoodsRefillResponse.class, new Object[0]).getBody();
        LOGGER.info(rsp.toString());
        if (null != JSON.parseObject((String)rsp.getBody()).getJSONObject("rp_returngoods_refill_response")) {
            return true;
        }
        throw new BusinessException("999999", rsp.getBody() + "   \u5929\u732b\u9000\u6b3e\u5355\u53f7\uff1a" + refundId);
    }

    public Boolean taoBaoReturnGoodsRefuse(Long refundId, String fileName, byte[] refuseProof, Long refuseReasonId, String channelCode) throws ApiException {
        RpReturngoodsRefuseRequestDTO req = new RpReturngoodsRefuseRequestDTO();
        req.setRefundId(refundId);
        req.setRefuseProof(new FileItem(fileName, refuseProof));
        req.setRefuseReasonId(refuseReasonId);
        req.setChannelCode(channelCode);
        RpReturngoodsRefuseResponse rsp = (RpReturngoodsRefuseResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taoBaoReturnGoodsRefuse", (Object)req, RpReturngoodsRefuseResponse.class, new Object[0]).getBody();
        LOGGER.info(rsp.toString());
        if (null != JSON.parseObject((String)rsp.getBody()).getJSONObject("rp_returngoods_refuse_response")) {
            return true;
        }
        throw new BusinessException("999999", rsp.getBody() + "   \u5929\u732b\u9000\u6b3e\u5355\u53f7\uff1a" + refundId);
    }

    public JSONArray taobaoRefundMessageGet(Long refundId, String channelCode) throws ApiException {
        JSONArray jsonArray = null;
        RefundMessagesGetRequestDTO req = new RefundMessagesGetRequestDTO();
        req.setFields("id,refund_id,owner_nick,content,created,owner_id,message_type,pic_urls");
        req.setRefundId(refundId);
        req.setChannelCode(channelCode);
        RefundMessagesGetResponse rsp = (RefundMessagesGetResponse)this.restTemplate.postForEntity(this.tmallJushitaUrl + "/refunds/taobaoRefundMessageGet", (Object)req, RefundMessagesGetResponse.class, new Object[0]).getBody();
        JSONObject jsonObject = JSON.parseObject((String)rsp.getBody());
        LOGGER.info("tmall\u54cd\u5e94\u4fe1\u606f\uff1a" + jsonObject.toJSONString());
        if (jsonObject.get((Object)"error_response") != null) {
            return null;
        }
        jsonArray = jsonObject.getJSONObject("refund_messages_get_response").getJSONObject("refund_messages").getJSONArray("refund_message");
        System.out.println(jsonArray.toJSONString());
        return jsonArray;
    }

    public TradeGetResponse taoBaoTradeDetailGet(Long tid, String channelCode) {
        TradeGetRequestDTO requestDTO = new TradeGetRequestDTO();
        requestDTO.setFields("tid,type,status,payment,orders,consign_time");
        requestDTO.setTid(tid);
        requestDTO.setChannelCode(channelCode);
        TradeGetResponse rsp = (TradeGetResponse)this.restTemplate.postForEntity("http://121.89.195.0/refunds/taoBaoTradeDetailGet", (Object)requestDTO, TradeGetResponse.class, new Object[0]).getBody();
        return rsp;
    }
}

