/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util;

import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.member.util.DateTool;
import com.thebeastshop.member.vo.MemberLevelRecordVO;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.message.enums.MsgTypeEnum;
import com.thebeastshop.message.enums.PriorityEnum;
import com.thebeastshop.message.enums.PublishTypeEnum;
import com.thebeastshop.message.vo.MsgSingleVo;
import com.thebeastshop.op.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMessageMemberLevelutil {
    private static final Logger log = LoggerFactory.getLogger(SendMessageMemberLevelutil.class);

    public static List<MsgSingleVo> coverInterfaceVO(List<MemberLevelRecordVO> memberLevelRecords, int type, int levelChannel) {
        if (EmptyUtil.isEmpty(memberLevelRecords)) {
            return null;
        }
        ArrayList<MsgSingleVo> msgSingleVos = new ArrayList<MsgSingleVo>();
        for (MemberLevelRecordVO memberLevelRecord : memberLevelRecords) {
            MsgSingleVo msgSingleVo = SendMessageMemberLevelutil.setInterfacVO(memberLevelRecord, type, levelChannel);
            if (null == msgSingleVo) continue;
            msgSingleVos.add(msgSingleVo);
        }
        log.info("\u4fe1\u606f  interfaceVo={}", msgSingleVos);
        return msgSingleVos;
    }

    public static List<MsgSingleVo> converSingleVOByOpMember(List<MemberVO> opMembers, int type) {
        if (EmptyUtil.isEmpty(opMembers)) {
            return null;
        }
        ArrayList<MsgSingleVo> msgSingleVos = new ArrayList<MsgSingleVo>();
        for (MemberVO member : opMembers) {
            MsgSingleVo msgSingleVo;
            if (member.getMemberLevel().equals(MemberLevelEnum.VIP4.getCode()) || null == (msgSingleVo = SendMessageMemberLevelutil.setOpmember(member, type))) continue;
            msgSingleVos.add(msgSingleVo);
        }
        return msgSingleVos;
    }

    private static MsgSingleVo setOpmember(MemberVO opMember, int type) {
        MsgSingleVo msgSingleVo = null;
        if (type == 1) {
            msgSingleVo = new MsgSingleVo();
            msgSingleVo.setPublishType(PublishTypeEnum.MEMBER_NOTIFY);
            msgSingleVo.setMsgType(MsgTypeEnum.ItnMsg);
            int level = -1;
            level = MemberLevelEnum.getLevelByCode((int)opMember.getStartupLevel()) >= MemberLevelEnum.getLevelByCode((int)opMember.getMemberLevel()) ? opMember.getStartupLevel().intValue() : opMember.getMemberLevel().intValue();
            msgSingleVo.setContent(String.format("\u4f60\u7684\u3010%s\u3011\u5c06\u4e8e\u4e0b\u6708\u5230\u671f\uff0c\u5feb\u6765\u770b\u770b\u5982\u4f55HOLD\u4f4f\u66f4\u591a\u4f1a\u5458\u6743\u76ca\u3002 ", SendMessageMemberLevelutil.getLevelName(level)));
            msgSingleVo.setTitle("\u4f60\u7684\u4f1a\u5458\u7b49\u7ea7\u5373\u5c06\u91cd\u65b0\u6838\u7b97");
            msgSingleVo.setDeepLink("{\"deepLink\":\"beastapp://benefit\"}");
            msgSingleVo.setMsgTo(opMember.getCode());
            msgSingleVo.setInvalidTime(DateUtils.addTime(opMember.getLastLevelUpdateTime(), 1, 1));
            msgSingleVo.setPriority(PriorityEnum.MIDDLE);
        }
        if (type == 2) {
            String phone = "";
            if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isNotBlank((CharSequence)opMember.getMobile())) {
                phone = opMember.getMobile();
            }
            if (StringUtils.isBlank((CharSequence)phone) && StringUtils.isNotBlank((CharSequence)opMember.getVerifiedMobile())) {
                phone = opMember.getVerifiedMobile();
            }
            if (StringUtils.isNotBlank((CharSequence)phone)) {
                msgSingleVo = new MsgSingleVo();
                if (StringUtils.isNotEmpty((CharSequence)opMember.getMobileCode())) {
                    msgSingleVo.setCountryNumber(opMember.getMobileCode());
                    msgSingleVo.setPublishType(PublishTypeEnum.INTERNATIONAL);
                } else {
                    msgSingleVo.setPublishType(PublishTypeEnum.MARKETING);
                }
                msgSingleVo.setMsgType(MsgTypeEnum.SmsMsg);
                int level = -1;
                level = MemberLevelEnum.getLevelByCode((int)opMember.getStartupLevel()) >= MemberLevelEnum.getLevelByCode((int)opMember.getMemberLevel()) ? opMember.getStartupLevel().intValue() : opMember.getMemberLevel().intValue();
                msgSingleVo.setContent(String.format("\u4eb2\u7231\u7684\u3010%s\u3011\uff0c\u4f60\u5f53\u524d\u7684\u4f1a\u7c4d\u6709\u6548\u671f\u5c06\u4e8e\u4e0b\u6708\u5230\u671f\uff0c\u5c4a\u65f6\u5c06\u6839\u636e\u60a8\u6700\u8fd112\u4e2a\u6708\u5185\u6d88\u8d39\u91d1\u989d\u91cd\u65b0\u6838\u7b97\u4f1a\u5458\u7b49\u7ea7\u3002\u5feb\u6253\u5f00\u91ce\u517d\u6d3eAPP,\u8fdb\u5165\u4e2a\u4eba\u4e2d\u5fc3\u770b\u770b\u5982\u4f55HOLD\u4f4f\u66f4\u591a\u4f1a\u5458\u6743\u76ca\u3002 ", SendMessageMemberLevelutil.getLevelName(level)));
                msgSingleVo.setTitle(null);
                msgSingleVo.setDeepLink(null);
                msgSingleVo.setMsgTo(phone);
                msgSingleVo.setPriority(PriorityEnum.MIDDLE);
            }
        }
        return msgSingleVo;
    }

    private static MsgSingleVo setInterfacVO(MemberLevelRecordVO memberLevelRecord, int type, int levelChannel) {
        MsgSingleVo msgSingleVo = null;
        if (type == 1) {
            if (levelChannel == 0) {
                msgSingleVo = new MsgSingleVo();
                msgSingleVo.setPublishType(PublishTypeEnum.MEMBER_NOTIFY);
                msgSingleVo.setMsgType(MsgTypeEnum.ItnMsg);
                msgSingleVo.setContent(String.format("\u606d\u559c\u4f60\u8363\u5347\u3010%s\u3011\u4f1a\u5458\uff0c\u5feb\u6765\u4e2a\u4eba\u4e2d\u5fc3\u9886\u793c\u5305\uff01", SendMessageMemberLevelutil.getLevelName(memberLevelRecord.getChannelLevel())));
                msgSingleVo.setTitle(String.format("\u606d\u559c\u4f60\u8363\u5347\u3010%s\u3011", SendMessageMemberLevelutil.getLevelName(memberLevelRecord.getChannelLevel())));
                msgSingleVo.setDeepLink("{\"deepLink\":\"beastapp://benefit\"}");
                msgSingleVo.setMsgTo(memberLevelRecord.getMemberCode());
                msgSingleVo.setInvalidTime(SendMessageMemberLevelutil.getMemberUpExpireMsg(memberLevelRecord.getCreateAt()));
                msgSingleVo.setPriority(PriorityEnum.HIGH);
            } else {
                msgSingleVo = new MsgSingleVo();
                msgSingleVo.setPublishType(PublishTypeEnum.MEMBER_NOTIFY);
                msgSingleVo.setMsgType(MsgTypeEnum.ItnMsg);
                msgSingleVo.setContent(String.format("\u4eb2\u7231\u7684\u4f1a\u5458\uff0c\u6839\u636e\u4f60\u8fd112\u4e2a\u6708\u7684\u6d88\u8d39\u603b\u91d1\u989d\uff0c\u4f60\u6700\u65b0\u7684\u4f1a\u5458\u7b49\u7ea7\u4e3a\u3010%s\u3011\u3002\u70b9\u6b64\u8fdb\u5165\u4f1a\u5458\u4e2d\u5fc3\uff0c\u67e5\u770b\u5f53\u524d\u4f1a\u5458\u6743\u76ca\u3002", SendMessageMemberLevelutil.getLevelName(memberLevelRecord.getChannelLevel())));
                msgSingleVo.setTitle("\u4f60\u7684\u4f1a\u5458\u7b49\u7ea7\u5df2\u66f4\u65b0");
                msgSingleVo.setDeepLink("{\"deepLink\":\"beastapp://benefit\"}");
                msgSingleVo.setMsgTo(memberLevelRecord.getMemberCode());
                msgSingleVo.setInvalidTime(SendMessageMemberLevelutil.getMemberDownExpireMsg(memberLevelRecord.getCreateAt()));
                msgSingleVo.setPriority(PriorityEnum.MIDDLE);
            }
        }
        if (type == 2) {
            // empty if block
        }
        if (type == 4 && levelChannel == 0) {
            msgSingleVo = new MsgSingleVo();
            msgSingleVo.setPublishType(PublishTypeEnum.MEMBER_NOTIFY);
            msgSingleVo.setMsgType(MsgTypeEnum.PushMsg);
            msgSingleVo.setContent(String.format("\u606d\u559c\u4f60\u8363\u5347\u3010%s\u3011\uff0c\u5feb\u6765\u4e2a\u4eba\u4e2d\u5fc3\u9886\u793c\u5305\uff01", SendMessageMemberLevelutil.getLevelName(memberLevelRecord.getChannelLevel())));
            msgSingleVo.setTitle(String.format("\u606d\u559c\u4f60\u8363\u5347\u3010%s\u3011", SendMessageMemberLevelutil.getLevelName(memberLevelRecord.getChannelLevel())));
            msgSingleVo.setDeepLink("{\"deepLink\":\"beastapp://benefit\"}");
            msgSingleVo.setMsgTo(memberLevelRecord.getMemberCode());
            msgSingleVo.setInvalidTime(SendMessageMemberLevelutil.getMemberUpExpireMsg(memberLevelRecord.getCreateAt()));
            msgSingleVo.setPriority(PriorityEnum.HIGH);
        }
        return msgSingleVo;
    }

    private static String getLevelName(Integer channelLevel) {
        String name = "";
        switch (channelLevel) {
            case -1: {
                name = "\u6ce8\u518c\u4f1a\u5458";
                break;
            }
            case 0: {
                name = "\u677e\u9f20\u4f1a\u5458";
                break;
            }
            case 1: {
                name = "\u5c0f\u732b\u4f1a\u5458";
                break;
            }
            case 2: {
                name = "\u8001\u864e\u4f1a\u5458";
                break;
            }
            case 3: {
                name = "\u5927\u8c61\u4f1a\u5458";
                break;
            }
            case 4: {
                name = "\u5154\u5b50\u4f1a\u5458";
            }
        }
        return name;
    }

    private static Date getMemberUpExpireMsg(Date d) {
        Date bc = DateTool.addDays((Date)d, (int)7);
        String c = DateTool.date2String((Date)bc, (String)"yyyy-MM-dd");
        c = c + " 23:59:59";
        return DateTool.string2Date((String)c, (String)"yyyy-MM-dd HH:mm:ss");
    }

    private static Date getMemberDownExpireMsg(Date d) {
        String c = DateTool.date2String((Date)d, (String)"yyyy-MM-dd");
        c = c + " 23:59:59";
        return DateTool.string2Date((String)c, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public static List<MsgSingleVo> converBirthdayMessageVOByOpMember(List<MemberVO> opMembers, int type, Date birthday) {
        if (EmptyUtil.isEmpty(opMembers)) {
            return null;
        }
        ArrayList<MsgSingleVo> msgSingleVos = new ArrayList<MsgSingleVo>();
        for (MemberVO member : opMembers) {
            Date invalidTime;
            MsgSingleVo msgSingleVo = SendMessageMemberLevelutil.setBirthdayMember(member, type, invalidTime = SendMessageMemberLevelutil.getInvalidTime(birthday, member.getMemberLevel()));
            if (null == msgSingleVo) continue;
            msgSingleVos.add(msgSingleVo);
        }
        return msgSingleVos;
    }

    private static MsgSingleVo setBirthdayMember(MemberVO opMember, int type, Date invalidTime) {
        MsgSingleVo msgSingleVo = null;
        if (type == 1) {
            msgSingleVo = new MsgSingleVo();
            msgSingleVo.setPublishType(PublishTypeEnum.MEMBER_NOTIFY);
            msgSingleVo.setMsgType(MsgTypeEnum.ItnMsg);
            msgSingleVo.setContent("\u91ce\u517d\u6d3e\u795d\u4f60\u751f\u65e5\u5feb\u4e50\uff01\u5feb\u6765\u67e5\u770b\u8001\u677f\u5a18\u4e3a\u4f60\u51c6\u5907\u7684\u751f\u65e5\u5927\u793c\uff01");
            msgSingleVo.setTitle(String.format("\u4eb2\u7231\u7684%s\uff0c\u751f\u65e5\u5feb\u4e50", opMember.getNickName()));
            msgSingleVo.setDeepLink("{\"deepLink\":\"beastapp://benefit\"}");
            msgSingleVo.setMsgTo(opMember.getCode());
            msgSingleVo.setInvalidTime(invalidTime);
            msgSingleVo.setPriority(PriorityEnum.HIGH);
        }
        if (type == 4) {
            msgSingleVo = new MsgSingleVo();
            msgSingleVo.setPublishType(PublishTypeEnum.MEMBER_NOTIFY);
            msgSingleVo.setMsgType(MsgTypeEnum.PushMsg);
            msgSingleVo.setContent("\u91ce\u517d\u6d3e\u795d\u4f60\u751f\u65e5\u5feb\u4e50\uff01\u5feb\u6765\u67e5\u770b\u8001\u677f\u5a18\u4e3a\u4f60\u51c6\u5907\u7684\u751f\u65e5\u5927\u793c\uff01");
            msgSingleVo.setTitle(String.format("\u4eb2\u7231\u7684%s\uff0c\u751f\u65e5\u5feb\u4e50", opMember.getNickName()));
            msgSingleVo.setDeepLink("{\"deepLink\":\"beastapp://benefit\"}");
            msgSingleVo.setMsgTo(opMember.getCode());
            msgSingleVo.setInvalidTime(invalidTime);
            msgSingleVo.setPriority(PriorityEnum.HIGH);
        }
        log.info("\u6d88\u606f\u7c7b\u578b\u662f type\uff1a{}\uff0c\u6d88\u606f\u5185\u5bb9\u662f content\uff1a{}\uff0c\u6d88\u606f\u53d1\u9001\u7ed9 nickname\uff1a{}", new Object[]{msgSingleVo.getMsgType().getName(), msgSingleVo.getContent(), opMember.getNickName()});
        return msgSingleVo;
    }

    private static Date getInvalidTime(Date birthday, Integer levle) {
        if (null != levle && levle > 0) {
            birthday = DateUtil.addDay((Date)birthday, (int)7);
        }
        Date endAt = DateUtil.dayEnd((Date)birthday);
        return endAt;
    }
}

