/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeBucket {
    private static final ThreadLocal<DateFormat> FORMATS = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private final Date start;
    private final Date end;

    public TimeBucket(Date start, Date end) {
        if (start.after(end)) {
            throw new IllegalArgumentException("\u65f6\u95f4\u6bb5\u65e0\u6548(\u5f00\u59cb\u65e5\u671f\u9700\u8981\u5c0f\u4e8e\u7ed3\u675f\u65e5\u671f)");
        }
        this.start = start;
        this.end = end;
    }

    public TimeBucket(String start, String end) throws ParseException {
        this(TimeBucket.parse(start), TimeBucket.parse(end));
    }

    public TimeBucket(long startTime, long endTime) {
        this(new Date(startTime), new Date(endTime));
    }

    public static TimeBucket union(TimeBucket ... buckets) {
        if (buckets == null || buckets.length <= 1) {
            return null;
        }
        for (int i = 0; i < buckets.length - 1; ++i) {
            long start = buckets[i].getStartTime();
            long end = buckets[i].getEndTime();
            for (int j = i + 1; j < buckets.length; ++j) {
                if (buckets[j].getStartTime() > start) {
                    start = buckets[j].getStartTime();
                }
                if (buckets[j].getEndTime() < end) {
                    end = buckets[j].getEndTime();
                }
                if (start >= end) continue;
                return new TimeBucket(start, end);
            }
        }
        return null;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public long getStartTime() {
        return this.start.getTime();
    }

    public long getEndTime() {
        return this.end.getTime();
    }

    private static Date parse(String str) throws ParseException {
        return FORMATS.get().parse(str);
    }

    private static String format(Date str) {
        return FORMATS.get().format(str);
    }

    public static void main(String[] args) throws ParseException {
        TimeBucket[] buckets = new TimeBucket[]{new TimeBucket("2018-05-02 00:00:00", "2018-06-10 00:00:00"), new TimeBucket("2018-06-02 00:10:10", "2018-10-29 1:00:00")};
        TimeBucket union = TimeBucket.union(buckets);
        if (null != union) {
            System.out.println("\u5b58\u5728\u91cd\u53e0\u533a\u57df,\u91cd\u53e0\u65f6\u95f4\u6bb5:" + union.toString());
        }
    }
}

