/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MONTH = 2592000000L;
    public static final long YEAR = 31536000000L;
    public static final Log LOGGER = LogFactory.getLog(DateUtils.class);

    public static boolean valid(String str) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = formatter.parse(str);
            return str.equals(formatter.format(date));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date stringToDate(String str) {
        String strFormat = "yyyy-MM-dd HH:mm";
        if (str != null && str.length() == 10) {
            strFormat = "yyyy-MM-dd";
        }
        SimpleDateFormat sdFormat = new SimpleDateFormat(strFormat);
        Date date = new Date();
        try {
            date = sdFormat.parse(str);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Date stringToDate(String str, String strFormat) {
        SimpleDateFormat sdFormat = new SimpleDateFormat(strFormat);
        Date date = new Date();
        try {
            date = sdFormat.parse(str);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Date stringToMongoDate(String str, String strFormat) {
        SimpleDateFormat sdFormat = new SimpleDateFormat(strFormat);
        sdFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = new Date();
        try {
            date = sdFormat.parse(str);
        }
        catch (Exception e) {
            return null;
        }
        return date;
    }

    public static Date getDaysInPast(int numDay) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(new Date().getTime() - 86400000L * (long)numDay), (int)5);
    }

    public static Date getDaysInPast(Date date, int numDay) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(date.getTime() - 86400000L * (long)numDay), (int)5);
    }

    public static Date getDaysInAdd(int numDay) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(new Date().getTime() + 86400000L * (long)numDay), (int)5);
    }

    public static Date getDaysInAdd(Date date, int numDay) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(date.getTime() + 86400000L * (long)numDay), (int)5);
    }

    public static Date getTomorrow(Date date) {
        if (date == null) {
            return null;
        }
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(date.getTime() + 86400000L), (int)5);
    }

    public static Date getHoursInFuture(Date date, int numhour) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(date.getTime() + 3600000L * (long)numhour), (int)12);
    }

    public static Date getHoursInPast(Date date, int numhour) {
        return org.apache.commons.lang.time.DateUtils.truncate((Date)new Date(date.getTime() - 3600000L * (long)numhour), (int)12);
    }

    public static Timestamp dateToTimestamp(Date date) {
        Calendar tCal = Calendar.getInstance();
        tCal.setTime(date);
        Timestamp ts = new Timestamp(tCal.getTime().getTime());
        return ts;
    }

    public static Timestamp stringToTimestamp(String str) {
        String strFormat = "yyyy-MM-dd HH:mm:ss";
        Date date = DateUtils.stringToDate(str, strFormat);
        Calendar tCal = Calendar.getInstance();
        tCal.setTime(date);
        Timestamp ts = new Timestamp(tCal.getTime().getTime());
        return ts;
    }

    public static String dateToYMD(Date dt) {
        SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd");
        String str = "";
        try {
            str = sdFormat.format(dt);
        }
        catch (Exception e) {
            return "";
        }
        if (str.equals("1900-01-01")) {
            str = "";
        }
        return str;
    }

    public static String dateToString(Date dt) {
        SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String str = "";
        try {
            str = sdFormat.format(dt);
        }
        catch (Exception e) {
            return "";
        }
        if (str.equals("1900-01-01 00:00")) {
            str = "";
        }
        return str;
    }

    public static String dateToString(Date dt, String strFormat) {
        SimpleDateFormat sdFormat = new SimpleDateFormat(strFormat);
        String str = "";
        try {
            if (dt != null) {
                str = sdFormat.format(dt);
            }
        }
        catch (Exception e) {
            return "";
        }
        if (str.equals("1900-01-01 00:00")) {
            str = "";
        }
        return str;
    }

    public static String getDateStr(String sFormat) {
        Calendar tCal = Calendar.getInstance();
        Timestamp ts = new Timestamp(tCal.getTime().getTime());
        Date date = new Date(ts.getTime());
        SimpleDateFormat formatter = new SimpleDateFormat(sFormat);
        String tmpStr = formatter.format(date);
        return tmpStr;
    }

    public static String getDateFormat(Timestamp ts, String sFormat) {
        Date date = new Date(ts.getTime());
        SimpleDateFormat formatter = new SimpleDateFormat(sFormat);
        String tmpStr = formatter.format(date);
        return tmpStr;
    }

    public static String getNextDay(String date) {
        if (date == null || date.trim().length() == 0) {
            return "";
        }
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(f.parse(date));
        }
        catch (ParseException ex) {
            return date;
        }
        calendar.add(5, 1);
        return f.format(calendar.getTime());
    }

    public static int dateDiff(Timestamp dt1, Timestamp dt2) {
        long ldate1 = dt1.getTime();
        long ldate2 = dt2.getTime();
        return (int)((ldate2 - ldate1) / 60000L);
    }

    public static int dateDiff(Date dt1, Date dt2) {
        long ldate1 = dt1.getTime();
        long ldate2 = dt2.getTime();
        return (int)((ldate2 - ldate1) / 60000L);
    }

    public static long getSecond(Date d1, Date d2) {
        long a1 = d1.getTime();
        long a2 = d2.getTime();
        long a3 = (a1 - a2) / 1000L;
        return a3;
    }

    public static int daysBetween(Date smdate, Date bdate) {
        long between_days = 0L;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            between_days = (time2 - time1) / 86400000L;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int daysBetween(String smdate, String bdate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setTime(sdf.parse(smdate));
        long time1 = cal.getTimeInMillis();
        cal.setTime(sdf.parse(bdate));
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static long getDayNum(Date d1, Date d2) {
        long a1 = d1.getTime();
        long a2 = d2.getTime();
        long a3 = (a2 - a1) / 86400000L;
        return a3;
    }

    public static String getBeapartDate(long m) {
        String beapartdate = "";
        int nDay = (int)m / 86400;
        int nHour = (int)(m - (long)(nDay * 24 * 60 * 60)) / 3600;
        int nMinute = (int)(m - (long)(nDay * 24 * 60 * 60) - (long)(nHour * 60 * 60)) / 60;
        beapartdate = Math.abs(nDay) + "\u5929" + Math.abs(nHour) + "\u5c0f\u65f6" + Math.abs(nMinute) + "\u5206";
        return beapartdate;
    }

    public static boolean checkDate(String date) {
        boolean ret = true;
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            df.setLenient(false);
            ret = df.format(df.parse(date)).equals(date);
        }
        catch (ParseException e) {
            LOGGER.info((Object)"\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
            ret = false;
            return ret;
        }
        String eL = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1][0-9])|([2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$";
        Pattern p = Pattern.compile(eL);
        Matcher m = p.matcher(date);
        boolean b = m.matches();
        if (!b) {
            LOGGER.info((Object)(date + "\u683c\u5f0f\u9519\u8bef"));
        }
        return b;
    }

    public static String getCurrentHMSSSS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmssSSS");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String getCurrentHMSS() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String getCurrentDateYYMMDD() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyMMdd");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String getCurrentDateYYYYMMDD() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static String getCurrentDateYYYYMMDDHHMMSSsss() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Date currentTime = new Date();
        return formatter.format(currentTime);
    }

    public static boolean isYesterday(Date date) {
        Calendar todayCal = Calendar.getInstance();
        todayCal.setTime(new Date());
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(date);
        dateCal.add(6, 1);
        return dateCal.get(6) == todayCal.get(6);
    }

    public static String getDilei(Date arriveTime) {
        if (!DateUtils.dateToYMD(arriveTime).equals(DateUtils.dateToYMD(new Date()))) {
            return "1";
        }
        return "0";
    }

    public static String getDescTime(Timestamp date_) {
        Date date = new Date(date_.getTime());
        String tody = "\u4eca\u5929 ";
        String todySDF = "HH:mm";
        String yesterDaySDF = "\u6628\u5929 ";
        String beforYesterDaySDF = "\u524d\u5929 ";
        String otherYearSDF = "yyyy/MM/dd";
        SimpleDateFormat sfd = null;
        String time = "";
        Date now = new Date();
        if (DateUtils.daysBetween(date, now) == 0) {
            sfd = new SimpleDateFormat(todySDF);
            time = sfd.format(date);
            return tody + time;
        }
        if (DateUtils.daysBetween(date, now) == 1) {
            sfd = new SimpleDateFormat(todySDF);
            time = sfd.format(date);
            time = yesterDaySDF + time;
            return time;
        }
        if (DateUtils.daysBetween(date, now) == 2) {
            sfd = new SimpleDateFormat(todySDF);
            time = sfd.format(date);
            time = beforYesterDaySDF + time;
            return time;
        }
        sfd = new SimpleDateFormat(otherYearSDF);
        time = sfd.format(date);
        return time;
    }

    public static String getDescTime_(Timestamp date_) {
        Date date = new Date(date_.getTime());
        String tody = "\u4eca\u5929";
        String todySDF = "HH:mm";
        String yesterDaySDF = "\u6628\u5929";
        String beforYesterDaySDF = "\u524d\u5929";
        String otherYearSDF = "yyyy/MM/dd";
        SimpleDateFormat sfd = null;
        String time = "";
        Date now = new Date();
        if (DateUtils.daysBetween(date, now) == 0) {
            return tody;
        }
        if (DateUtils.daysBetween(date, now) == 1) {
            return yesterDaySDF;
        }
        if (DateUtils.daysBetween(date, now) == 2) {
            return beforYesterDaySDF;
        }
        sfd = new SimpleDateFormat(otherYearSDF);
        time = sfd.format(date);
        return time;
    }

    public static String getOpenTime(String opentime) {
        String retTime = "09:30";
        if (opentime == null || opentime.length() < 5) {
            retTime = "09:30";
        } else if (opentime.length() == 5) {
            int a = Integer.parseInt(opentime.substring(0, 2));
            if (a < 9) {
                retTime = "09:30";
            } else if (a == 9) {
                int b = Integer.parseInt(opentime.substring(3, 5));
                if (b < 30) {
                    retTime = "09:30";
                }
            } else {
                retTime = opentime;
            }
        }
        return retTime;
    }

    public static String getCloseTime(String closetime) {
        String retTime = "21:30";
        if (closetime == null || closetime.length() < 5) {
            retTime = "21:30";
        } else if (closetime.length() == 5) {
            int b;
            int a = Integer.parseInt(closetime.substring(0, 2));
            retTime = a >= 22 ? "21:30" : (a == 21 ? ((b = Integer.parseInt(closetime.substring(3, 5))) > 30 ? "21:30" : closetime) : closetime);
        }
        return retTime;
    }

    public static boolean isLaterThenTime(String ctime, String time) {
        int th1 = Integer.parseInt(ctime.split(":")[0]);
        int tm1 = Integer.parseInt(ctime.split(":")[1]);
        int th2 = Integer.parseInt(time.split(":")[0]);
        int tm2 = Integer.parseInt(time.split(":")[1]);
        if (th1 > th2) {
            return true;
        }
        return th1 == th2 && tm1 > tm2;
    }

    public static boolean nowInTimearea(String time1, String time2) {
        Calendar c = Calendar.getInstance();
        int ch = c.get(11);
        int cm = c.get(12);
        String ctime = ch + ":" + cm;
        return DateUtils.isLaterThenTime(ctime, time1) && DateUtils.isLaterThenTime(time2, ctime);
    }

    public static Timestamp getCurrDateTime() {
        Calendar tCal = Calendar.getInstance();
        Timestamp createDate = new Timestamp(tCal.getTime().getTime());
        return createDate;
    }

    public static String getToday() {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(ts);
    }

    public static int compareDate(String DATE1, String DATE2) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date dt1 = df.parse(DATE1);
            Date dt2 = df.parse(DATE2);
            if (dt1.getTime() > dt2.getTime()) {
                return 1;
            }
            if (dt1.getTime() < dt2.getTime()) {
                return -1;
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }

    public static String getTomorrow() {
        return DateUtils.getNextDay(DateUtils.getToday());
    }

    public static String dateToHasWeekString(Date dt) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFm = new SimpleDateFormat("EEEE");
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(dateFormat.format(dt)).append(" ");
            sb.append(dateFm.format(dt)).append(" ");
            sb.append(timeFormat.format(dt));
        }
        catch (Exception e) {
            return "";
        }
        return sb.toString();
    }

    public static String dateTimeToHasWeekString(Date dt1, Date dt2) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFm = new SimpleDateFormat("EEEE", Locale.CHINA);
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
        StringBuilder sb = new StringBuilder();
        try {
            sb.append(dateFormat.format(dt1)).append(" ");
            sb.append(dateFm.format(dt1)).append(" ");
            sb.append(timeFormat.format(dt1)).append(" - ");
            sb.append(timeFormat.format(dt2));
        }
        catch (Exception e) {
            return "";
        }
        return sb.toString();
    }

    public static Date addHours(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(11, num);
        return cal.getTime();
    }

    public static Date addTime(Date date, int num, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, num);
        return cal.getTime();
    }

    public static String getConfigurationDate(long m) {
        String beapartdate = "";
        int nDay = Math.abs((int)m / 86400);
        int nHour = Math.abs((int)(m - (long)(nDay * 24 * 60 * 60)) / 3600);
        int nMinute = Math.abs((int)(m - (long)(nDay * 24 * 60 * 60) - (long)(nHour * 60 * 60)) / 60);
        String hour = nHour + "";
        String minute = nMinute + "";
        if (nDay > 0) {
            beapartdate = beapartdate + nDay + "\u5929";
        }
        if (nHour > 0) {
            beapartdate = beapartdate + hour + "\u5c0f\u65f6";
        }
        if (nMinute > 0) {
            beapartdate = beapartdate + minute + "\u5206\u949f";
        }
        return beapartdate;
    }

    public static Date addWorkDay(Date date, int num) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int mod = num % 5;
        int other = num / 5 * 7;
        int i = 0;
        block3: while (i < mod) {
            cal.add(5, 1);
            switch (cal.get(7)) {
                case 1: 
                case 7: {
                    continue block3;
                }
            }
            ++i;
        }
        if (other > 0) {
            cal.add(5, other);
        }
        return cal.getTime();
    }

    public static String dateToWeek(String datetime) {
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd");
        String[] weekDays = new String[]{"7", "1", "2", "3", "4", "5", "6"};
        Calendar cal = Calendar.getInstance();
        Date datet = null;
        try {
            datet = f.parse(datetime);
            cal.setTime(datet);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }
}

