/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.op.vo;

import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.op.enums.ChannelTypeEnum;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class OpPresaleVO
implements Serializable {
    private Long id;
    private Date createTime;
    private String presaleDesc;
    private Integer presaleStatus;
    private String skuCode;
    private Date openTime;
    private Date closeTime;
    private Date planedDeliveryDate;
    private Integer totalQuantity;
    private String dispatchWarehouseCode;
    private Integer needNotify;
    private Date notifyTime;
    private String notifyEmail;
    private Integer createOperatorId;
    private String createOperatorName;
    private Integer channelType;
    private Integer allotedQuantity;
    private Integer whetherConvergence;
    private Date effectiveTime;
    private Date lastAuditTime;
    private Date lastSubmitTime;
    private String lastApproverName;
    private String lastAuditRemark;
    private Integer lastApprover;
    public static final Integer STATUS_DISABLED = 0;
    public static final Integer STATUS_ENABLE = 1;
    public static final Integer STATUS_WAITAPPROVAL = 2;
    public static final Integer STATUS_REJECT = 3;
    public static final Integer STATUS_CANCEL = 4;
    public static final Integer STATUS_WAITSTART = -1;
    public static final Integer CHANNEL_TYPE_BEAST = 0;
    public static final Integer CHANNEL_TYPE_THIRDPARTY = 1;
    public static final Integer CHANNEL_TYPE_TMALL = 10;
    public static final Integer CHANNEL_TYPE_JD = 11;
    public static final Integer CHANNEL_TYPE_TMALL_JIAFANG = 12;
    public static final Integer CHANNEL_TYPE_OFFLINE = 13;
    public static final Integer CHANNEL_TYPE_TMALL_HOME = 14;
    public static final Integer CHANNEL_TYPE_JD_HOME = 15;
    public static final Integer CHANNEL_TYPE_TMALL_NAKED = 16;
    public static final Integer CHANNEL_TYPE_TMALL_LITTLEB = 17;
    private String skuName;
    private String dispatchWarehouseName;
    private Integer saledQuantity;
    private Integer groupBuyOccupyQuantity;
    private Integer convertedQuantity;
    private Integer deliveriedQuantity;
    private String buyerName;
    private String categoryName;
    private String verifyRemind;
    List<String> auditDatas;
    private Integer synThirdParty;
    private Long thirdPartyGoodsId;
    private String thirdPartyGoodsTitle;
    private Long thirdPartySkuId;

    public Integer getWhetherConvergence() {
        return this.whetherConvergence;
    }

    public void setWhetherConvergence(Integer whetherConvergence) {
        this.whetherConvergence = whetherConvergence;
    }

    public Date getEffectiveTime() {
        return this.effectiveTime;
    }

    public void setEffectiveTime(Date effectiveTime) {
        this.effectiveTime = effectiveTime;
    }

    public Integer getChannelType() {
        return this.channelType;
    }

    public void setChannelType(Integer channelType) {
        this.channelType = channelType;
    }

    public Integer getAllotedQuantity() {
        return this.allotedQuantity;
    }

    public void setAllotedQuantity(Integer allotedQuantity) {
        this.allotedQuantity = allotedQuantity;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getPresaleDesc() {
        return this.presaleDesc;
    }

    public void setPresaleDesc(String presaleDesc) {
        this.presaleDesc = presaleDesc == null ? null : presaleDesc.trim();
    }

    public Integer getPresaleStatus() {
        return this.presaleStatus;
    }

    public void setPresaleStatus(Integer presaleStatus) {
        this.presaleStatus = presaleStatus;
    }

    public String getSkuCode() {
        return this.skuCode;
    }

    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode == null ? null : skuCode.trim();
    }

    public Date getOpenTime() {
        return this.openTime;
    }

    public void setOpenTime(Date openTime) {
        this.openTime = openTime;
    }

    public Date getCloseTime() {
        return this.closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public Date getPlanedDeliveryDate() {
        return this.planedDeliveryDate;
    }

    public void setPlanedDeliveryDate(Date planedDeliveryDate) {
        this.planedDeliveryDate = planedDeliveryDate;
    }

    public Integer getTotalQuantity() {
        return this.totalQuantity;
    }

    public void setTotalQuantity(Integer totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public String getDispatchWarehouseCode() {
        return this.dispatchWarehouseCode;
    }

    public void setDispatchWarehouseCode(String dispatchWarehouseCode) {
        this.dispatchWarehouseCode = dispatchWarehouseCode == null ? null : dispatchWarehouseCode.trim();
    }

    public Integer getNeedNotify() {
        return this.needNotify;
    }

    public void setNeedNotify(Integer needNotify) {
        this.needNotify = needNotify;
    }

    public Date getNotifyTime() {
        return this.notifyTime;
    }

    public void setNotifyTime(Date notifyTime) {
        this.notifyTime = notifyTime;
    }

    public String getNotifyEmail() {
        return this.notifyEmail;
    }

    public void setNotifyEmail(String notifyEmail) {
        this.notifyEmail = notifyEmail == null ? null : notifyEmail.trim();
    }

    public Integer getCreateOperatorId() {
        return this.createOperatorId;
    }

    public void setCreateOperatorId(Integer createOperatorId) {
        this.createOperatorId = createOperatorId;
    }

    public String getCreateOperatorName() {
        return this.createOperatorName;
    }

    public void setCreateOperatorName(String createOperatorName) {
        this.createOperatorName = createOperatorName == null ? null : createOperatorName.trim();
    }

    public Date getLastAuditTime() {
        return this.lastAuditTime;
    }

    public void setLastAuditTime(Date lastAuditTime) {
        this.lastAuditTime = lastAuditTime;
    }

    public Date getLastSubmitTime() {
        return this.lastSubmitTime;
    }

    public void setLastSubmitTime(Date lastSubmitTime) {
        this.lastSubmitTime = lastSubmitTime;
    }

    public String getLastApproverName() {
        return this.lastApproverName;
    }

    public void setLastApproverName(String lastApproverName) {
        this.lastApproverName = lastApproverName;
    }

    public String getLastAuditRemark() {
        return this.lastAuditRemark;
    }

    public void setLastAuditRemark(String lastAuditRemark) {
        this.lastAuditRemark = lastAuditRemark;
    }

    public Integer getLastApprover() {
        return this.lastApprover;
    }

    public void setLastApprover(Integer lastApprover) {
        this.lastApprover = lastApprover;
    }

    public Integer getGroupBuyOccupyQuantity() {
        return this.groupBuyOccupyQuantity;
    }

    public void setGroupBuyOccupyQuantity(Integer groupBuyOccupyQuantity) {
        this.groupBuyOccupyQuantity = groupBuyOccupyQuantity;
    }

    public List<String> getAuditDatas() {
        return this.auditDatas;
    }

    public void setAuditDatas(List<String> auditDatas) {
        this.auditDatas = auditDatas;
    }

    public String getChannelTypeName() {
        ChannelTypeEnum typeEnum;
        if (this.channelType != null && (typeEnum = ChannelTypeEnum.getEnumByCode(this.channelType)) != null) {
            return typeEnum.getName();
        }
        return "";
    }

    public String getVerifyRemind() {
        return this.verifyRemind;
    }

    public void setVerifyRemind(String verifyRemind) {
        this.verifyRemind = verifyRemind;
    }

    public Integer getDeliveriedQuantity() {
        return this.deliveriedQuantity;
    }

    public void setDeliveriedQuantity(Integer deliveriedQuantity) {
        this.deliveriedQuantity = deliveriedQuantity;
    }

    public Integer getConvertedQuantity() {
        return this.convertedQuantity;
    }

    public void setConvertedQuantity(Integer convertedQuantity) {
        this.convertedQuantity = convertedQuantity;
    }

    public Integer getSaledQuantity() {
        return this.saledQuantity;
    }

    public void setSaledQuantity(Integer saledQuantity) {
        this.saledQuantity = saledQuantity;
    }

    public String getDispatchWarehouseName() {
        return this.dispatchWarehouseName;
    }

    public void setDispatchWarehouseName(String dispatchWarehouseName) {
        this.dispatchWarehouseName = dispatchWarehouseName;
    }

    public String getSkuName() {
        return this.skuName;
    }

    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    public String getBuyerName() {
        return this.buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getOpenTimeStr() {
        if (this.openTime == null) {
            return "";
        }
        return DateUtil.format((Date)this.openTime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getCloseTimeStr() {
        if (this.closeTime == null) {
            return "";
        }
        return DateUtil.format((Date)this.closeTime, (String)"yyyy-MM-dd HH:mm:ss");
    }

    public String getPlanedDeliveryDateStr() {
        if (this.planedDeliveryDate == null) {
            return "";
        }
        return DateUtil.format((Date)this.planedDeliveryDate, (String)"yyyy-MM-dd");
    }

    public boolean getCanEdit() {
        return DateUtil.getNow().compareTo(this.closeTime) < 0;
    }

    public Integer getSynThirdParty() {
        return this.synThirdParty;
    }

    public void setSynThirdParty(Integer synThirdParty) {
        this.synThirdParty = synThirdParty;
    }

    public Long getThirdPartyGoodsId() {
        return this.thirdPartyGoodsId;
    }

    public void setThirdPartyGoodsId(Long thirdPartyGoodsId) {
        this.thirdPartyGoodsId = thirdPartyGoodsId;
    }

    public String getThirdPartyGoodsTitle() {
        return this.thirdPartyGoodsTitle;
    }

    public void setThirdPartyGoodsTitle(String thirdPartyGoodsTitle) {
        this.thirdPartyGoodsTitle = thirdPartyGoodsTitle;
    }

    public Long getThirdPartySkuId() {
        return this.thirdPartySkuId;
    }

    public void setThirdPartySkuId(Long thirdPartySkuId) {
        this.thirdPartySkuId = thirdPartySkuId;
    }

    public boolean getCanEditOpenTime() {
        return DateUtil.getNow().compareTo(this.openTime) < 0;
    }

    public boolean getPlanedDeliveryDateCanEdit() {
        boolean status = this.getCanEdit();
        if (!status && this.totalQuantity != null && this.allotedQuantity != null && this.allotedQuantity < this.totalQuantity) {
            Date nowDatePart = DateUtil.dayStart((Date)new Date());
            if (this.presaleStatus != null && this.presaleStatus == 0 && this.planedDeliveryDate != null && this.planedDeliveryDate.compareTo(nowDatePart) >= 0) {
                status = true;
            }
        }
        return status;
    }

    public String getPresaleStatusStr() {
        if (this.presaleStatus == null) {
            return "";
        }
        if (this.presaleStatus == STATUS_DISABLED) {
            return "\u7981\u7528";
        }
        if (this.presaleStatus == STATUS_ENABLE) {
            return "\u542f\u7528";
        }
        if (this.presaleStatus == STATUS_WAITAPPROVAL) {
            return "\u5f85\u5ba1\u6279";
        }
        if (this.presaleStatus == STATUS_REJECT) {
            return "\u9a73\u56de";
        }
        if (this.presaleStatus == STATUS_CANCEL) {
            return "\u53d6\u6d88";
        }
        if (this.presaleStatus == STATUS_WAITSTART) {
            return "\u5f85\u542f\u7528";
        }
        return "ErrorStatus";
    }

    public String getNeedNotifyStr() {
        if (this.needNotify == null) {
            return "";
        }
        if (this.needNotify == 0) {
            return "N";
        }
        if (this.needNotify == 1) {
            return "Y";
        }
        return "ErrorStatus";
    }

    public String getNeedNotifyName() {
        if (this.needNotify == null) {
            return "";
        }
        if (this.needNotify == 0) {
            return "\u5426";
        }
        if (this.needNotify == 1) {
            return "\u662f";
        }
        return "\u9519\u8bef";
    }

    public String getPresaleStatusName() {
        if (this.presaleStatus == null) {
            return "";
        }
        if (this.presaleStatus == 0) {
            return "\u5426";
        }
        if (this.presaleStatus == 1) {
            return "\u662f";
        }
        return "\u9519\u8bef";
    }

    public String getChannelTypeStr() {
        if (this.channelType == null) {
            return null;
        }
        if (this.channelType == CHANNEL_TYPE_BEAST) {
            return "\u5b98\u7f51";
        }
        if (this.channelType == CHANNEL_TYPE_THIRDPARTY) {
            return "\u7b2c\u4e09\u65b9";
        }
        if (this.channelType == CHANNEL_TYPE_TMALL) {
            return "\u5929\u732b";
        }
        if (this.channelType == CHANNEL_TYPE_JD) {
            return "\u4eac\u4e1c";
        }
        if (this.channelType == CHANNEL_TYPE_TMALL_JIAFANG) {
            return "\u5929\u732b\u5bb6\u7eba";
        }
        if (this.channelType == CHANNEL_TYPE_OFFLINE) {
            return "\u7ebf\u4e0b";
        }
        if (this.channelType == CHANNEL_TYPE_TMALL_HOME) {
            return "\u5929\u732bHome";
        }
        if (this.channelType == CHANNEL_TYPE_JD_HOME) {
            return "\u4eac\u4e1cHome";
        }
        if (this.channelType == CHANNEL_TYPE_TMALL_NAKED) {
            return "\u5929\u732bNaked";
        }
        if (this.channelType == CHANNEL_TYPE_TMALL_LITTLEB) {
            return "\u5929\u732bLittleB";
        }
        return "ErrorStatus";
    }

    public static Integer translateChannelType(String channelStr) {
        if ("\u5b98\u7f51".equals(channelStr)) {
            return CHANNEL_TYPE_BEAST;
        }
        if ("\u5929\u732b".equals(channelStr)) {
            return CHANNEL_TYPE_TMALL;
        }
        if ("\u4eac\u4e1c".equals(channelStr)) {
            return CHANNEL_TYPE_JD;
        }
        if ("\u5929\u732b\u5bb6\u7eba".equals(channelStr)) {
            return CHANNEL_TYPE_TMALL_JIAFANG;
        }
        if ("\u7b2c\u4e09\u65b9".equals(channelStr)) {
            return CHANNEL_TYPE_THIRDPARTY;
        }
        if ("\u7ebf\u4e0b".equals(channelStr)) {
            return CHANNEL_TYPE_OFFLINE;
        }
        if ("\u5929\u732bHome".equals(channelStr)) {
            return CHANNEL_TYPE_TMALL_HOME;
        }
        if ("\u4eac\u4e1cHome".equals(channelStr)) {
            return CHANNEL_TYPE_JD_HOME;
        }
        if ("\u5929\u732bNaked".equals(channelStr)) {
            return CHANNEL_TYPE_TMALL_NAKED;
        }
        if ("\u5929\u732bLittleB".equals(channelStr)) {
            return CHANNEL_TYPE_TMALL_LITTLEB;
        }
        return CHANNEL_TYPE_BEAST;
    }
}

