/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.ecp;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.ecp.EcpDeliveryReceipt;
import com.thebeastshop.common.ecp.EcpRequest;
import com.thebeastshop.common.ecp.EcpResponse;
import com.thebeastshop.common.ecp.HttpRemoteData;
import com.thebeastshop.common.utils.EmptyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class EcpUtils {
    private static final Logger log = LoggerFactory.getLogger(EcpUtils.class);

    public static EcpResponse ecpDeliveryReceipt(EcpDeliveryReceipt ecpDeliveryReceipt) throws Exception {
        String expresscode = ecpDeliveryReceipt.getExpresscode();
        String expressno = ecpDeliveryReceipt.getExpressno();
        Assert.isTrue((boolean)EmptyUtil.isNotEmpty((String)expresscode), (String)"\u7269\u6d41\u516c\u53f8\u552f\u4e00\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)EmptyUtil.isNotEmpty((String)expressno), (String)"\u5feb\u9012\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        EcpRequest ecpRequest = new EcpRequest();
        EcpResponse ecpResponse = new EcpResponse();
        HttpRemoteData httpClient = new HttpRemoteData();
        httpClient.SetAppKey(ecpRequest.get_AppKey());
        httpClient.SetSecretKey(EcpRequest.Secretkey);
        httpClient.SetSessionKey(ecpRequest.get_SessionKey());
        httpClient.SetUrl(EcpRequest.ECP_DELIVERY_RECEIPT_GATEWAY);
        httpClient.AddMethod("ecp.scm.wmsFeedback.deliveryFeedback");
        ecpDeliveryReceipt.setExpresscode(EcpUtils.getEcpExpressType(Integer.parseInt(ecpDeliveryReceipt.getExpresscode())));
        log.info("\u7269\u6d41\u5f00\u59cb\u56de\u6267\uff1a\u3010\u53d1\u8d27\u5355\u53f7: {},\u7269\u6d41\u65b9\u5f0f\uff1a{}, \u7269\u6d41\u5355\u53f7\uff1a{}\u3011", new Object[]{ecpDeliveryReceipt.getOrderno(), ecpDeliveryReceipt.getExpresscode(), ecpDeliveryReceipt.getExpressno()});
        httpClient.AddParam("content", JSON.toJSONString((Object)ecpDeliveryReceipt));
        if (httpClient.DoPost()) {
            ecpResponse.setStatus(1);
            ecpResponse.setMsg(httpClient.GetResponse());
        } else {
            ecpResponse.setStatus(0);
            ecpResponse.setMsg(httpClient.GetLastError());
        }
        log.info("\u7269\u6d41\u56de\u6267\u7ed3\u679c\uff1a\u3010\u53d1\u8d27\u5355\u53f7: {}, {}\u3011", (Object)ecpDeliveryReceipt.getOrderno(), (Object)JSON.toJSONString((Object)ecpResponse));
        return ecpResponse;
    }

    public static String getEcpExpressType(int expressType) {
        String res;
        switch (expressType) {
            case 1: {
                res = "\u95e8\u5e97";
                break;
            }
            case 2: {
                res = "FEDEX";
                break;
            }
            case 3: {
                res = "SF";
                break;
            }
            case 4: {
                res = "SF";
                break;
            }
            case 5: {
                res = "YTO";
                break;
            }
            case 6: {
                res = "\u5fb7\u90a6";
                break;
            }
            case 7: {
                res = "\u987a\u4e30(\u6d77\u6dd8)";
                break;
            }
            case 8: {
                res = "OTHER";
                break;
            }
            case 9: {
                res = "ZTO";
                break;
            }
            case 10: {
                res = "OTHER";
                break;
            }
            case 11: {
                res = "OTHER";
                break;
            }
            case 12: {
                res = "SF";
                break;
            }
            case 16: {
                res = "JD";
                break;
            }
            case 17: {
                res = "JD";
                break;
            }
            case 19: {
                res = "SF";
                break;
            }
            case 20: {
                res = "POSTB";
                break;
            }
            case 21: {
                res = "EMS";
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }
}

