/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils.route;

import com.thebeastshop.common.utils.route.DBType;
import com.thebeastshop.common.utils.route.DBTypeHolder;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.mybatis.spring.transaction.SpringManagedTransaction;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.util.Assert;

public class ScmSpringManagedTransaction
extends SpringManagedTransaction {
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final DataSource slaveDataSouce;
    private final DataSource msterDataSouce;
    private Connection connection;
    private Connection slaveConnection;
    private boolean isConnectionTransactional;
    private boolean autoCommit;

    public ScmSpringManagedTransaction(DataSource dataSource, DataSource slaveDataSouce) {
        super(dataSource);
        this.msterDataSouce = dataSource;
        this.slaveDataSouce = slaveDataSouce;
        Assert.notNull((Object)dataSource, (String)"No DataSource specified");
    }

    public Connection getConnection() throws SQLException {
        if (DBType.SLAVE.equals((Object)DBTypeHolder.getDBType())) {
            if (this.slaveConnection == null) {
                this.openSlaveConnection();
            }
            return this.slaveConnection;
        }
        if (this.connection == null) {
            this.openConnection();
        }
        return this.connection;
    }

    private void openSlaveConnection() throws SQLException {
        this.slaveConnection = DataSourceUtils.getConnection((DataSource)this.msterDataSouce);
    }

    private void openConnection() throws SQLException {
        this.connection = DataSourceUtils.getConnection((DataSource)this.msterDataSouce);
        this.autoCommit = this.connection.getAutoCommit();
        this.isConnectionTransactional = DataSourceUtils.isConnectionTransactional((Connection)this.connection, (DataSource)this.msterDataSouce);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("JDBC Connection [" + this.connection + "] will" + (this.isConnectionTransactional ? " " : " not ") + "be managed by Spring");
        }
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Committing JDBC Connection [" + this.connection + "]");
            }
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.isConnectionTransactional && !this.autoCommit) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Rolling back JDBC Connection [" + this.connection + "]");
            }
            this.connection.rollback();
        }
    }

    public void close() throws SQLException {
        DataSourceUtils.releaseConnection((Connection)this.connection, (DataSource)this.msterDataSouce);
        DataSourceUtils.releaseConnection((Connection)this.slaveConnection, (DataSource)this.slaveDataSouce);
    }
}

