/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.exception.UtilException;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.ErrorMessage;
import com.thebeastshop.common.utils.ExcelColumn;
import com.thebeastshop.common.utils.ExcelColumnNumber;
import com.thebeastshop.common.utils.ExcelTemplate;
import com.thebeastshop.common.utils.XSSFDateUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.validation.Validator;

@Component(value="poiParseExcelComponentNew")
@Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class PoiParseExcelComponentNew<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiParseExcelComponentNew.class);
    private static final String excel2003L = ".xls";
    private static final String excel2007U = ".xlsx";
    private Class<T> clazz;
    private InputStream is;
    private int headerRowIndex = 0;
    private int firstRowIndex = 1;
    private String fileName;
    private List<ObjectError> errorMessages = new ArrayList<ObjectError>();
    private List<String> warnMessages = new ArrayList<String>();
    private Set<String> warnMessagesSet = new HashSet<String>();
    private Set<String> headerColumn = new HashSet<String>();
    private Map<Integer, Field> columnMap = new HashMap<Integer, Field>();
    private Map<String, String> fieldNameMap = new HashMap<String, String>();
    private List<T> availableResults = new ArrayList<T>();
    private List<T> allResults = new ArrayList<T>();
    private List<T> failureResults = new ArrayList<T>();
    private Method setErrorMsgMethod;
    private Method getErrorMsgMethod;
    private Method setColumnNumberMethod;
    @Autowired
    private Validator beanVidator;
    @Autowired
    private ConversionService myConversionService;

    public void parse(InputStream is, Class<T> clazz, String fileName, Integer headerRowIndex, Integer firstRowIndex) {
        this.is = is;
        this.clazz = clazz;
        this.fileName = fileName;
        this.headerRowIndex = headerRowIndex;
        this.firstRowIndex = firstRowIndex;
        this.validateExcel();
    }

    public void parse(File file, Class<T> clazz) {
        if (file == null) {
            throw new IllegalArgumentException("the file is null!");
        }
        try {
            this.is = new FileInputStream(file);
            this.clazz = clazz;
            this.validateExcel();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
    }

    public void parse(String fileName, Class<T> clazz) {
        if (fileName == null || fileName.trim().length() < 1) {
            throw new IllegalArgumentException("the file path is empty");
        }
        File file = new File(fileName);
        try {
            this.is = new FileInputStream(file);
            this.clazz = clazz;
            this.validateExcel();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
    }

    public List<T> getAvailableResults() {
        return this.availableResults;
    }

    public List<ObjectError> getErrorMessages() {
        return this.errorMessages;
    }

    public String getErrorInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.errorMessages != null && this.errorMessages.size() > 0) {
            for (ObjectError error : this.errorMessages) {
                stringBuffer.append(error.getDefaultMessage().replace("must not be null", "\u4e0d\u80fd\u4e3a\u7a7a"));
                stringBuffer.append("</br>");
            }
        }
        return stringBuffer.toString();
    }

    public List<T> getFailureResults() {
        return this.failureResults;
    }

    public List<T> getAllResults() {
        return this.allResults;
    }

    public boolean hasErrors() {
        return this.errorMessages.size() > 0;
    }

    public List<String> getWarnMessages() {
        return this.warnMessages;
    }

    public boolean hasWarns() {
        return this.warnMessages.size() > 0;
    }

    private void validateExcel() {
        ExcelTemplate et = this.clazz.getAnnotation(ExcelTemplate.class);
        if (et == null) {
            throw new RuntimeException("the class is not a excel template data");
        }
        try {
            Workbook wb = this.getWorkbook(this.is, this.fileName);
            Sheet sheet = wb.getSheetAt(0);
            if (sheet.getPhysicalNumberOfRows() <= 1) {
                this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                return;
            }
            Row firstRow = sheet.getRow(this.headerRowIndex);
            if (sheet.getLastRowNum() < 1) {
                this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u6ca1\u6709\u7b2c\u4e00\u884c\uff0c\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                return;
            }
            this.checkExcelHeader(firstRow);
            if (this.errorMessages.size() > 0) {
                return;
            }
            if (this.headerColumn.size() < 1) {
                this.errorMessages.add(new ObjectError(this.clazz.getName(), "Excel\u6587\u4ef6\u7b2c\u4e00\u884c\u7684\u5217\u540d\u4e0e\u6a21\u677f\u5b8c\u5168\u4e0d\u7b26,\u8bf7\u4e25\u683c\u6309\u7167\u7ed9\u5b9a\u7684\u683c\u5f0f\u751f\u6210excel\u6587\u4ef6!"));
                return;
            }
            this.initErrorMessageAndColumnNumberMehtod();
            this.convertToJavaBean(sheet);
            int rowTip = this.firstRowIndex;
            for (T t : this.allResults) {
                this.validate(t, rowTip);
                ++rowTip;
            }
            this.checkUniqueConstrain();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
    }

    private void checkExcelHeader(Row firstRow) {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Class<T> temp = this.clazz; temp != null && !temp.equals(Object.class) && temp.getAnnotation(ExcelTemplate.class) != null; temp = temp.getSuperclass()) {
            Field[] fs = temp.getDeclaredFields();
            for (int x = 0; x < fs.length; ++x) {
                ExcelColumn ec = fs[x].getAnnotation(ExcelColumn.class);
                if (ec == null) continue;
                fieldsList.add(fs[x]);
            }
        }
        int firstCellNum = firstRow.getFirstCellNum();
        short lastCellNum = firstRow.getLastCellNum();
        for (int i = firstCellNum; i < lastCellNum; ++i) {
            String content = firstRow.getCell(i).getStringCellValue();
            if (content == null || content.trim().length() < 1) continue;
            content = content.trim();
            for (int j = 0; j < fieldsList.size(); ++j) {
                ExcelColumn ec = ((Field)fieldsList.get(j)).getAnnotation(ExcelColumn.class);
                if (ec == null) continue;
                String columnName = ec.name().equals("") ? ((Field)fieldsList.get(j)).getName() : ec.name();
                this.fieldNameMap.put(((Field)fieldsList.get(j)).getName(), ec.name());
                if (!content.equals(columnName)) continue;
                if (!this.headerColumn.add(columnName)) {
                    this.errorMessages.add(new ObjectError(this.clazz.getName(), "\u5728\u6a21\u677f\u4e2d\u53d1\u73b0\u6709\u91cd\u590d\u7684\u5217\u540d" + columnName));
                    continue;
                }
                this.columnMap.put(i, (Field)fieldsList.get(j));
            }
        }
    }

    private void convertToJavaBean(Sheet sheet) {
        try {
            int rowNum = sheet.getLastRowNum();
            for (int i = this.firstRowIndex; i <= rowNum; ++i) {
                T obj = this.clazz.newInstance();
                Row row = sheet.getRow(i);
                if (row == null) continue;
                int nullCount = 0;
                for (Integer j : this.columnMap.keySet()) {
                    Field field = this.columnMap.get(j);
                    if (field == null) {
                        ++nullCount;
                        continue;
                    }
                    if (j < row.getLastCellNum()) {
                        String chineseName = this.fieldNameMap.get(field.getName()).length() < 1 ? field.getName() : this.fieldNameMap.get(field.getName());
                        Cell cell = row.getCell(j.intValue());
                        if (cell == null) {
                            ++nullCount;
                            continue;
                        }
                        if (2 == cell.getCellType()) {
                            this.warnMessages.add("[\u7b2c" + (i + 1) + "\u884c] " + chineseName + "\u5b58\u5728\u516c\u5f0f\uff0c\u65e0\u6cd5\u4e0a\u4f20");
                            this.warnMessagesSet.add(chineseName + (i + 1));
                            this.errorMessages.add((ObjectError)new FieldError(this.clazz.getName(), field.getName(), "[\u7b2c" + (i + 1) + "]\u884c " + chineseName + "\u5b58\u5728\u516c\u5f0f\uff0c\u65e0\u6cd5\u4e0a\u4f20"));
                            continue;
                        }
                        Object content = this.getCellValue(cell, field.getType().getName());
                        if (content != null) {
                            Method method = this.clazz.getMethod(this.generateSetMethod(field.getName()), field.getType());
                            if (!String.class.getName().equals(field.getType().getName())) {
                                try {
                                    if (Date.class.getName().equals(field.getType().getName())) {
                                        TimeZone zone = TimeZone.getTimeZone("GMT");
                                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                        sdf.setTimeZone(zone);
                                        if (!EmptyUtil.isNotEmpty((Object)content)) continue;
                                        if (content instanceof Date) {
                                            method.invoke(obj, this.myConversionService.convert(content, field.getType()));
                                            continue;
                                        }
                                        Date date = DateUtil.parseDate((String)content.toString(), (String)"yyyy-MM-dd HH:mm:ss");
                                        if (date == null) {
                                            date = DateUtil.parseDate((String)content.toString(), (String)"yyyy-MM-dd");
                                        }
                                        if (date == null) {
                                            date = DateUtil.parse((String)content.toString(), (String)"yyyy/MM/dd");
                                        }
                                        method.invoke(obj, this.myConversionService.convert((Object)date, field.getType()));
                                        continue;
                                    }
                                    method.invoke(obj, this.myConversionService.convert(content, field.getType()));
                                }
                                catch (Exception e) {
                                    LOGGER.error("convertToJavaBean-error", (Throwable)e);
                                    this.warnMessages.add("[\u7b2c" + (i + 1) + "\u884c] " + chineseName + "\u683c\u5f0f\u4e0d\u6b63\u786e");
                                    this.warnMessagesSet.add(chineseName + (i + 1));
                                    this.errorMessages.add((ObjectError)new FieldError(this.clazz.getName(), field.getName(), "[\u7b2c" + (i + 1) + "\u884c] " + chineseName + "\u683c\u5f0f\u4e0d\u6b63\u786e"));
                                }
                                continue;
                            }
                            method.invoke(obj, content);
                            continue;
                        }
                        ++nullCount;
                        continue;
                    }
                    ++nullCount;
                }
                if (this.columnMap.size() <= nullCount) continue;
                this.setExcelColumnNumber(obj, i + 1);
                this.allResults.add(obj);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new UtilException("UT2003", "EXCEL\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u683c\u5f0f\u662f\u5426\u89c4\u8303\uff01");
        }
    }

    private void validate(T obj, int row) {
        BindException errors = new BindException(obj, this.clazz.getSimpleName());
        this.beanVidator.validate(obj, (Errors)errors);
        if (errors.hasErrors()) {
            for (FieldError error : errors.getFieldErrors()) {
                String chineseName;
                if (this.fieldNameMap.get(error.getField()) == null || this.warnMessagesSet.contains((chineseName = this.fieldNameMap.get(error.getField()).length() < 1 ? error.getField() : this.fieldNameMap.get(error.getField())) + row)) continue;
                this.errorMessages.add((ObjectError)new FieldError(error.getObjectName(), error.getField(), "[\u7b2c" + row + "\u884c] " + chineseName + error.getDefaultMessage()));
                this.setErrorMessage(obj, chineseName + error.getDefaultMessage());
            }
            this.failureResults.add(obj);
        } else {
            this.availableResults.add(obj);
        }
    }

    private void checkUniqueConstrain() {
        HashSet<Field> fields = new HashSet<Field>();
        for (int i : this.columnMap.keySet()) {
            Field field = this.columnMap.get(i);
            ExcelColumn ec = field.getAnnotation(ExcelColumn.class);
            if (ec == null || !ec.unique()) continue;
            fields.add(field);
        }
        if (fields.size() < 1) {
            return;
        }
        try {
            ArrayList<T> needToRemove = new ArrayList<T>();
            for (Field f : fields) {
                Method method = this.clazz.getMethod(this.generateGetMethod(f.getName()), new Class[0]);
                for (int i = 0; i < this.availableResults.size(); ++i) {
                    T t = this.availableResults.get(i);
                    Object obj = method.invoke(t, new Object[0]);
                    int rowDis = 2;
                    boolean hasIt = false;
                    String chineseName = this.fieldNameMap.get(f.getName()).length() < 1 ? f.getName() : this.fieldNameMap.get(f.getName());
                    for (int j = 0; j < this.availableResults.size(); ++j) {
                        T sub = this.availableResults.get(j);
                        if (j == i || needToRemove.contains(sub)) continue;
                        Object sobj = method.invoke(sub, new Object[0]);
                        if (obj == null || !obj.equals(sobj)) continue;
                        this.errorMessages.add((ObjectError)new FieldError(this.clazz.getName(), "multiple_" + f.getName(), "[\u7b2c" + (i + rowDis) + "\u884c\u548c\u7b2c" + (j + rowDis) + "\u884c] " + chineseName + "\u6570\u636e\u91cd\u590d!"));
                        this.setErrorMessage(sub, chineseName + "\u6570\u636e\u91cd\u590d!");
                        needToRemove.add(sub);
                        hasIt = true;
                    }
                    if (!hasIt) continue;
                    needToRemove.add(t);
                    this.setErrorMessage(t, chineseName + "\u6570\u636e\u91cd\u590d!");
                }
                if (needToRemove.size() > 0) {
                    this.availableResults.removeAll(needToRemove);
                    this.failureResults.addAll(needToRemove);
                }
                needToRemove.clear();
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void initErrorMessageAndColumnNumberMehtod() {
        Field[] fields = this.clazz.getDeclaredFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                ErrorMessage em = fields[i].getAnnotation(ErrorMessage.class);
                ExcelColumnNumber ecn = fields[i].getAnnotation(ExcelColumnNumber.class);
                if (em != null && this.setErrorMsgMethod == null) {
                    this.setErrorMsgMethod = this.clazz.getMethod(this.generateSetMethod(fields[i].getName()), fields[i].getType());
                    this.getErrorMsgMethod = this.clazz.getMethod(this.generateGetMethod(fields[i].getName()), new Class[0]);
                }
                if (ecn == null || this.setColumnNumberMethod != null) continue;
                this.setColumnNumberMethod = this.clazz.getMethod(this.generateSetMethod(fields[i].getName()), fields[i].getType());
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    private void setExcelColumnNumber(T obj, Integer number) {
        if (this.setColumnNumberMethod != null) {
            try {
                this.setColumnNumberMethod.invoke(obj, number);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void setErrorMessage(T obj, String message) {
        if (this.setErrorMsgMethod != null) {
            try {
                String em = this.getErrorMessage(obj);
                if (em != null && em.trim().length() > 0) {
                    this.setErrorMsgMethod.invoke(obj, em + ";" + message);
                } else {
                    this.setErrorMsgMethod.invoke(obj, message);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private String getErrorMessage(T obj) {
        if (this.getErrorMsgMethod != null) {
            try {
                return (String)this.getErrorMsgMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private String generateSetMethod(String fieldName) {
        if (fieldName == null || fieldName.length() < 1) {
            return "";
        }
        return "set" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
    }

    private String generateGetMethod(String fieldName) {
        if (fieldName == null || fieldName.length() < 1) {
            return "";
        }
        return "get" + fieldName.toUpperCase().charAt(0) + fieldName.substring(1);
    }

    public Workbook getWorkbook(InputStream inStr, String fileName) throws Exception {
        HSSFWorkbook wb = null;
        String fileType = fileName.substring(fileName.lastIndexOf("."));
        if (excel2003L.equals(fileType)) {
            wb = new HSSFWorkbook(inStr);
        } else if (excel2007U.equals(fileType)) {
            wb = new XSSFWorkbook(inStr);
        } else {
            throw new Exception("\u89e3\u6790\u7684\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\uff01");
        }
        return wb;
    }

    public Object getCellValue(Cell cell, String fieldType) {
        Object value = null;
        DecimalFormat df = new DecimalFormat("0");
        NumberFormat nf = NumberFormat.getInstance();
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                if (XSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    TimeZone zone = TimeZone.getTimeZone("GMT");
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    sdf.setTimeZone(zone);
                    System.out.print("YYYYYYYYYYYYYYYY\u65e5\u671f" + cell.getNumericCellValue());
                    value = cell.getDateCellValue();
                    System.out.println("YYYYYYYYYYYYYYYY\u65e5\u671f" + value);
                    break;
                }
                if ("java.math.BigDecimal".equals(fieldType)) {
                    df = new DecimalFormat("#########.####");
                    value = df.format(cell.getNumericCellValue());
                    break;
                }
                value = df.format(cell.getNumericCellValue());
                break;
            }
            case 2: {
                Workbook wb = cell.getSheet().getWorkbook();
                CreationHelper crateHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = crateHelper.createFormulaEvaluator();
                value = this.getCellValue(evaluator.evaluateInCell(cell), fieldType);
                break;
            }
            case 4: {
                value = cell.getBooleanCellValue();
                break;
            }
            case 3: {
                value = "";
                break;
            }
        }
        return value;
    }

    public static void main(String[] args) {
    }
}

