/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.utils.CompareStatus;
import com.thebeastshop.common.utils.DateUtil;
import com.thebeastshop.common.utils.EmptyUtil;
import com.thebeastshop.common.utils.ObjectChangeLog;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareObejct<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompareObejct.class);
    private CompareStatus status;
    private T original;
    private T current;
    private Class<T> tClass;
    private StringBuilder changeStringBuilder;

    public CompareObejct(T original, T current, Class<T> tClass) {
        this.original = original;
        this.current = current;
        this.tClass = tClass;
    }

    public CompareObejct(T original, T current, Class<T> tClass, StringBuilder changeStringBuilder) {
        this.original = original;
        this.current = current;
        this.tClass = tClass;
        this.changeStringBuilder = changeStringBuilder;
    }

    public CompareStatus getStatus() {
        return this.status;
    }

    public T getOriginal() {
        return this.original;
    }

    public void setOriginal(T original) {
        this.original = original;
    }

    public T getCurrent() {
        return this.current;
    }

    public void setCurrent(T current) {
        this.current = current;
    }

    public String contrastObj() {
        if (this.changeStringBuilder == null) {
            this.changeStringBuilder = new StringBuilder();
        }
        boolean allIsEqual = true;
        try {
            if (this.original == null) {
                Field[] fields;
                this.status = CompareStatus.NEW;
                for (Field field : fields = this.tClass.getDeclaredFields()) {
                    String s2;
                    ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                    if (objectChangeLog == null || objectChangeLog.logType() != 1) continue;
                    String filedName = objectChangeLog.name();
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), this.tClass);
                    Method getMethod = pd.getReadMethod();
                    Object o2 = getMethod.invoke(this.current, new Object[0]);
                    String string = s2 = o2 == null ? "" : o2.toString();
                    if (s2 == null || s2 == "") continue;
                    if (this.changeStringBuilder.length() != 0) {
                        this.changeStringBuilder.append(" | ");
                    }
                    this.changeStringBuilder.append("<font color=\"#FF0000\">" + filedName + "</font>\uff1a[" + s2 + "]");
                }
            } else {
                Field[] fields;
                for (Field field : fields = this.tClass.getDeclaredFields()) {
                    Object o2;
                    System.out.println(field.getName());
                    ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                    if (objectChangeLog == null || objectChangeLog.logType() != 1) continue;
                    String filedName = objectChangeLog.name();
                    String fieldTypeAnnotation = objectChangeLog.fieldType();
                    String fieldType = field.getType().getName();
                    PropertyDescriptor pd = new PropertyDescriptor(field.getName(), this.tClass);
                    Method getMethod = pd.getReadMethod();
                    Object o1 = this.original == null ? null : getMethod.invoke(this.original, new Object[0]);
                    Object object = o2 = this.current == null ? null : getMethod.invoke(this.current, new Object[0]);
                    if (fieldTypeAnnotation != "" && fieldTypeAnnotation.equals("java.lang.Class")) {
                        if (o1 == null && o2 == null) continue;
                        CompareObejct<Object> compareObejct = new CompareObejct<Object>(o1, o2, o1 == null ? o2.getClass() : o1.getClass(), this.changeStringBuilder);
                        compareObejct.contrastObj();
                        System.out.println(o1.getClass().getClass());
                        continue;
                    }
                    if (fieldType != "") {
                        if (fieldType.equals("java.util.Date")) {
                            if (o1 == null && o2 == null) continue;
                            o1 = o1 != null ? DateUtil.format((Date)((Date)o1), (String)objectChangeLog.dateTimeFormat()) : o1;
                            o2 = o2 != null ? DateUtil.format((Date)((Date)o2), (String)objectChangeLog.dateTimeFormat()) : o2;
                        } else if (!fieldType.equals("java.math.BigDecimal")) {
                            if (fieldType.equals("java.util.List")) {
                                if (o1 == null && o2 == null) continue;
                                o1 = this.getChangeStringBuilder((List)o1, objectChangeLog.getMethod());
                                o2 = this.getChangeStringBuilder((List)o2, objectChangeLog.getMethod());
                            } else if (fieldType.equals("java.lang.Boolean")) {
                                if (o1 == null && o2 == null) continue;
                                Object object2 = o1 != null ? (((Boolean)o1).booleanValue() ? "\u662f" : "\u5426") : (o1 = o1);
                                o2 = o2 != null ? (((Boolean)o2).booleanValue() ? "\u662f" : "\u5426") : o2;
                            }
                        }
                    }
                    String s1 = o1 == null ? "" : o1.toString();
                    String s2 = o2 == null ? "" : o2.toString();
                    boolean isEqual = true;
                    if (fieldType.equals("java.math.BigDecimal")) {
                        if (s1.equals("") && !s2.equals("") || !s1.equals("") && s2.equals("")) {
                            isEqual = false;
                        } else if (!s1.equals("") && !s2.equals("") && new BigDecimal(s1).compareTo(new BigDecimal(s2)) != 0) {
                            isEqual = false;
                        }
                    } else if (!s1.equals(s2)) {
                        isEqual = false;
                    }
                    if (isEqual) continue;
                    allIsEqual = true;
                    if (this.changeStringBuilder.length() != 0) {
                        this.changeStringBuilder.append(" | ");
                    }
                    this.changeStringBuilder.append("<font color=\"#FF0000\">" + filedName + "</font>\uff1a[" + s1 + "->" + s2 + "]");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.status = allIsEqual ? CompareStatus.NO_CHANGE : CompareStatus.CHANGE;
        return this.changeStringBuilder.toString();
    }

    private StringBuilder getChangeStringBuilder(List<?> list, String getMethod) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        StringBuilder logSb1 = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (Object child : list) {
                Method getChangeLog = child.getClass().getMethod(EmptyUtil.isEmpty((String)getMethod) ? "getChangeLog" : getMethod, new Class[0]);
                Object changeLog = getChangeLog.invoke(child, new Object[0]);
                logSb1.append(changeLog);
            }
        }
        return logSb1;
    }

    public boolean verifyChangeField() {
        try {
            Field[] fields;
            if (this.original == null) {
                return true;
            }
            for (Field field : fields = this.tClass.getDeclaredFields()) {
                Object o2;
                System.out.println(field.getName());
                ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                if (objectChangeLog == null) continue;
                String filedName = objectChangeLog.name();
                String fieldTypeAnnotation = objectChangeLog.fieldType();
                String fieldType = field.getType().getName();
                boolean needVerifyChanged = objectChangeLog.needVerifyChanged();
                if (!needVerifyChanged) continue;
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), this.tClass);
                Method getMethod = pd.getReadMethod();
                Object o1 = this.original == null ? null : getMethod.invoke(this.original, new Object[0]);
                Object object = o2 = this.current == null ? null : getMethod.invoke(this.current, new Object[0]);
                if (fieldTypeAnnotation != "" && fieldTypeAnnotation.equals("java.lang.Class")) {
                    CompareObejct<Object> compareObejct;
                    boolean fieldChanged;
                    if (o1 == null && o2 == null || !(fieldChanged = (compareObejct = new CompareObejct<Object>(o1, o2, o1 == null ? o2.getClass() : o1.getClass(), this.changeStringBuilder)).verifyChangeField())) continue;
                    return true;
                }
                if (fieldType != "") {
                    if (fieldType.equals("java.util.Date")) {
                        if (o1 == null && o2 == null) continue;
                        o1 = o1 != null ? DateUtil.format((Date)((Date)o1), (String)"yyyy-MM-dd HH:mm:ss") : o1;
                        o2 = o2 != null ? DateUtil.format((Date)((Date)o2), (String)"yyyy-MM-dd HH:mm:ss") : o2;
                    } else if (!fieldType.equals("java.math.BigDecimal")) {
                        if (fieldType.equals("java.util.List")) {
                            if (o1 == null && o2 == null) continue;
                            o1 = this.getChangeStringBuilder((List)o1, objectChangeLog.getMethod());
                            o2 = this.getChangeStringBuilder((List)o2, objectChangeLog.getMethod());
                        } else if (fieldType.equals("java.lang.Boolean")) {
                            if (o1 == null && o2 == null) continue;
                            Object object2 = o1 != null ? (((Boolean)o1).booleanValue() ? "\u662f" : "\u5426") : (o1 = o1);
                            o2 = o2 != null ? (((Boolean)o2).booleanValue() ? "\u662f" : "\u5426") : o2;
                        }
                    }
                }
                String s1 = o1 == null ? "" : o1.toString();
                String s2 = o2 == null ? "" : o2.toString();
                boolean isEqual = true;
                if (fieldType.equals("java.math.BigDecimal")) {
                    if (s1.equals("") && !s2.equals("") || !s1.equals("") && s2.equals("")) {
                        isEqual = false;
                    } else if (!s1.equals("") && !s2.equals("") && new BigDecimal(s1).compareTo(new BigDecimal(s2)) != 0) {
                        isEqual = false;
                    }
                } else if (!s1.equals(s2)) {
                    LOGGER.info("verifyChangeField: {}, {}", (Object)s1, (Object)s2);
                    return true;
                }
                if (isEqual) continue;
                LOGGER.info("verifyChangeField: {}, {}", (Object)s1, (Object)s2);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<String> getChangeFieldList() {
        ArrayList<String> changeFieldNameList = new ArrayList<String>();
        try {
            Field[] fields;
            if (this.original == null) {
                return changeFieldNameList;
            }
            for (Field field : fields = this.tClass.getDeclaredFields()) {
                Object o2;
                System.out.println(field.getName());
                ObjectChangeLog objectChangeLog = field.getAnnotation(ObjectChangeLog.class);
                if (objectChangeLog == null) continue;
                String filedName = objectChangeLog.name();
                String fieldTypeAnnotation = objectChangeLog.fieldType();
                String fieldType = field.getType().getName();
                boolean needVerifyChanged = objectChangeLog.needVerifyChanged();
                if (!needVerifyChanged) continue;
                PropertyDescriptor pd = new PropertyDescriptor(field.getName(), this.tClass);
                Method getMethod = pd.getReadMethod();
                Object o1 = this.original == null ? null : getMethod.invoke(this.original, new Object[0]);
                Object object = o2 = this.current == null ? null : getMethod.invoke(this.current, new Object[0]);
                if (fieldTypeAnnotation != "" && fieldTypeAnnotation.equals("java.lang.Class")) {
                    if (o1 == null && o2 == null) continue;
                    CompareObejct<Object> compareObejct = new CompareObejct<Object>(o1, o2, o1 == null ? o2.getClass() : o1.getClass(), this.changeStringBuilder);
                    changeFieldNameList.addAll(compareObejct.getChangeFieldList());
                    continue;
                }
                if (fieldType != "") {
                    if (fieldType.equals("java.util.Date")) {
                        if (o1 == null && o2 == null) continue;
                        o1 = o1 != null ? DateUtil.format((Date)((Date)o1), (String)"yyyy-MM-dd HH:mm:ss") : o1;
                        o2 = o2 != null ? DateUtil.format((Date)((Date)o2), (String)"yyyy-MM-dd HH:mm:ss") : o2;
                    } else if (!fieldType.equals("java.math.BigDecimal")) {
                        if (fieldType.equals("java.util.List")) {
                            if (o1 == null && o2 == null) continue;
                            o1 = this.getChangeStringBuilder((List)o1, objectChangeLog.getMethod());
                            o2 = this.getChangeStringBuilder((List)o2, objectChangeLog.getMethod());
                        } else if (fieldType.equals("java.lang.Boolean")) {
                            if (o1 == null && o2 == null) continue;
                            Object object2 = o1 != null ? (((Boolean)o1).booleanValue() ? "\u662f" : "\u5426") : (o1 = o1);
                            o2 = o2 != null ? (((Boolean)o2).booleanValue() ? "\u662f" : "\u5426") : o2;
                        }
                    }
                }
                String s1 = o1 == null ? "" : o1.toString();
                String s2 = o2 == null ? "" : o2.toString();
                boolean isEqual = true;
                if (fieldType.equals("java.math.BigDecimal")) {
                    if (s1.equals("") && !s2.equals("") || !s1.equals("") && s2.equals("")) {
                        isEqual = false;
                    } else if (!s1.equals("") && !s2.equals("") && new BigDecimal(s1).compareTo(new BigDecimal(s2)) != 0) {
                        isEqual = false;
                    }
                } else if (!s1.equals(s2)) {
                    LOGGER.info("verifyChangeField: {}, {}", (Object)s1, (Object)s2);
                    changeFieldNameList.add(field.getName());
                }
                if (isEqual) continue;
                LOGGER.info("verifyChangeField: {}, {}", (Object)s1, (Object)s2);
                changeFieldNameList.add(field.getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return changeFieldNameList;
    }
}

