/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Eric.Lou
 * @version $Id: TxtUtil.java, v 0.1 2015-11-03 10:13
 */
public class TxtUtil {

    private final static Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public final static String DEFAULT_ENCODING = "utf-8";

    /**
     * 逐行读取TXT
     *
     * @param is
     * @param encoding
     * @return List<String>
     */
    public static List<String> read(InputStream is, String encoding) {
        List<String> stringList = new ArrayList<String>();
        if(NullUtil.isNull(is)){
            return stringList;
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(is, encoding));
            String lineTxt = null;
            while (NullUtil.isNotNull(lineTxt = bufferedReader.readLine())) {
                if(!"".equals(lineTxt.trim())){
                    stringList.add(lineTxt);
                }
            }
        } catch (Exception e) {
            log.warn("TxtUtil readTxtFile 读取文件内容出错", e);
        } finally {
            IOUtils.closeQuietly(bufferedReader);
            IOUtils.closeQuietly(is);
        }
        return stringList;
    }

    /**
     * 逐行读取TXT
     *
     * @param is
     * @return List<String>
     */
    public static List<String> read(InputStream is) {
        return read(is,DEFAULT_ENCODING);
    }

    /**
     * 逐行读取TXT
     *
     * @param filePath
     * @param encoding
     * @return List<String>
     */
    public static List<String> read(String filePath, String encoding) {
        FileInputStream fis = null;
        try {
            File file = new File(filePath);
            if (file.isFile() && file.exists() && file.canRead()) {
                fis = new FileInputStream(file);
            }
        } catch (Exception e) {
            //ignore
        }
        return read(fis, encoding);
    }

    /**
     * 逐行读取TXT
     *
     * @param filePath
     * @return List<String>
     */
    public static List<String> read(String filePath) {
        return read(filePath, DEFAULT_ENCODING);
    }

}
