package com.thebeastshop.common.utils;



import java.io.Serializable;

public class ExcelRowCellTemplate implements Serializable {
    public ExcelRowCellTemplate() {}

    public ExcelRowCellTemplate(int rowIndex, int columnIndex, String cellValue) {
            this.rowNum = rowIndex;
            this.columnIndex = columnIndex;
            this.cellValue = cellValue;
        }

    public ExcelRowCellTemplate(int rowIndex, int columnIndex, String cellValue, ExcelCellStyle style) {
            this.rowNum = rowIndex;
            this.columnIndex = columnIndex;
            this.cellValue = cellValue;
            this.style = style;
        }

        /**
         * name : 上海野派电子商务有限公司
         * firstRow : 0
         * lastRow : 0
         * firstCol : 0
         * lastCol : 15
         * alignCenter : 0x2
         * verticalCenter : 0x1
         * fillPattern : 1
         * fillForegroundColor : 13
         * fontSize : 16
         * fontName : 宋体
         * rowNum : 6
         */
        private int columnIndex;
        private String cellValue;
        private Integer firstRow;
        private Integer lastRow;
        private Integer firstCol;
        private Integer lastCol;
        private Short alignCenter;
        private Short verticalCenter = 0x01;
        private Short fillPattern;
        private Short fillForegroundColor;
        private Short fontSize = 9;
        private String fontName = "宋体";
        private int rowNum;
        private boolean whetherToMergeCells = false;
        //是否超链接
        private boolean isLink = false;
        //是否插入一行
        private boolean insertRow = false;

        private boolean hasBorder = false;//有边框

        private ExcelCellStyle style;


    public String getCellValue() {
        return cellValue;
    }

    public void setCellValue(String cellValue) {
        this.cellValue = cellValue;
    }

    public Integer getFirstRow() {
        return firstRow;
    }

    public void setFirstRow(Integer firstRow) {
        this.firstRow = firstRow;
    }

    public Integer getLastRow() {
        return lastRow;
    }

    public void setLastRow(Integer lastRow) {
        this.lastRow = lastRow;
    }

    public Integer getFirstCol() {
        return firstCol;
    }

    public void setFirstCol(Integer firstCol) {
        this.firstCol = firstCol;
    }

    public Integer getLastCol() {
        return lastCol;
    }

    public void setLastCol(Integer lastCol) {
        this.lastCol = lastCol;
    }

    public Short getAlignCenter() {
        return alignCenter;
    }

    public void setAlignCenter(Short alignCenter) {
        this.alignCenter = alignCenter;
    }

    public Short getVerticalCenter() {
        return verticalCenter;
    }

    public void setVerticalCenter(Short verticalCenter) {
        this.verticalCenter = verticalCenter;
    }

    public Short getFillPattern() {
        return fillPattern;
    }

    public void setFillPattern(Short fillPattern) {
        this.fillPattern = fillPattern;
    }

    public Short getFillForegroundColor() {
        return fillForegroundColor;
    }

    public void setFillForegroundColor(Short fillForegroundColor) {
        this.fillForegroundColor = fillForegroundColor;
    }

    public Short getFontSize() {
        return fontSize;
    }

    public void setFontSize(Short fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getRowNum() {
        return rowNum;
    }

    public void setRowNum(int rowNum) {
        this.rowNum = rowNum;
    }

    public int getColumnIndex() {
        return columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public boolean isWhetherToMergeCells() {
        return whetherToMergeCells;
    }

    public void setWhetherToMergeCells(boolean whetherToMergeCells) {
        this.whetherToMergeCells = whetherToMergeCells;
    }

    public ExcelCellStyle getStyle() {
        return style;
    }

    public void setStyle(ExcelCellStyle style) {
        this.style = style;
    }

    public boolean isHasBorder() {
        return hasBorder;
    }

    public void setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
    }

    public boolean isLink() {
        return isLink;
    }

    public void setLink(boolean link) {
        isLink = link;
    }
}
