package com.thebeastshop.common.http;

import java.util.Map;

/**
 * @project unicom-repo
 *
 * @author <a href="mailto:me@yuanchongyu.com">Royan</a>
 *
 * @createDate 2012-12-29 上午10:43:24
 *
 */
public class HttpRequest{
	private String url;

	private String params;

	private Map<String, String> cookieMap;
	
	private Map<String, String> headerMap;

	private String host;
	
	private int timeOut = 0;

    private int soTimeout = 0;

	private boolean needCookie = true;
	
	private boolean needBody = true;
	
	private boolean needHeaderMap = false;
	
	public HttpRequest() {
        this(2000, 5000);
    }

    public HttpRequest(int timeOut, int soTimeout) {
        this.timeOut = timeOut;
        this.soTimeout = soTimeout;
    }

	public String getUrl(){
		return url;
	}

	public HttpRequest setUrl(String url){
		this.url = url;
		return this;
	}

	public String getParams(){
		return params;
	}

	public HttpRequest setParams(String params){
		this.params = params;
		return this;
	}

	public Map<String, String> getCookieMap(){
		return cookieMap;
	}

	public HttpRequest setCookieMap(Map<String, String> cookieMap){
		this.cookieMap = cookieMap;
		return this;
	}

	public String getHost(){
		return host;
	}

	public HttpRequest setHost(String host){
		this.host = host;
		return this;
	}
	
	public boolean isNeedCookie(){
		return needCookie;
	}

	public HttpRequest setNeedCookie(boolean needCookie){
		this.needCookie = needCookie;
		return this;
	}

	public boolean isNeedBody(){
		return needBody;
	}

	public HttpRequest setNeedBody(boolean needBody){
		this.needBody = needBody;
		return this;
	}

	public String getCookieStr(){
		String cookieStr = "";
		if (this.cookieMap != null) {
			cookieStr = HttpTool.cookie2Str(this.cookieMap);
		}
		return cookieStr;
	}

	public Map<String, String> getHeaderMap(){
		return headerMap;
	}

	public void setHeaderMap(Map<String, String> headerMap){
		this.headerMap = headerMap;
	}

	public boolean isNeedHeaderMap(){
		return needHeaderMap;
	}

	public HttpRequest setNeedHeaderMap(boolean needHeaderMap){
		this.needHeaderMap = needHeaderMap;
		return this;
	}

    public int getTimeOut() {
        return timeOut;
    }

    public void setTimeOut(int timeOut) {
        this.timeOut = timeOut;
    }

    public int getSoTimeout() {
        return soTimeout;
    }

    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

}
