package com.thebeastshop.common.ecp;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.common.utils.EmptyUtil;
import org.apache.http.HttpException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

import java.io.IOException;

public class EcpUtils {
	
	
	 private final static Logger log = LoggerFactory.getLogger(EcpUtils.class);
	/**
	 * ecp 物流信息回执
	 * @param ecpDeliveryReceipt
	 * @return
	 * @throws HttpException
	 * @throws IOException
	 */
	public  static EcpResponse ecpDeliveryReceipt(EcpDeliveryReceipt ecpDeliveryReceipt) throws Exception {

		String expresscode = ecpDeliveryReceipt.getExpresscode();
		String expressno = ecpDeliveryReceipt.getExpressno();
		Assert.isTrue(EmptyUtil.isNotEmpty(expresscode), "物流公司唯一编码不能为空");
		Assert.isTrue(EmptyUtil.isNotEmpty(expressno), "快递单号不能为空");

	    EcpRequest ecpRequest  = new EcpRequest();
	    EcpResponse ecpResponse = new EcpResponse();
	    HttpRemoteData httpClient=new HttpRemoteData();
	    httpClient.SetAppKey(ecpRequest.get_AppKey());
	    httpClient.SetSecretKey(EcpRequest.Secretkey);
	    httpClient.SetSessionKey(ecpRequest.get_SessionKey());
	    httpClient.SetUrl(EcpRequest.ECP_DELIVERY_RECEIPT_GATEWAY);
	    httpClient.AddMethod("ecp.scm.wmsFeedback.deliveryFeedback");
	    ecpDeliveryReceipt.setExpresscode(getEcpExpressType(Integer.parseInt(ecpDeliveryReceipt.getExpresscode())));

        log.info("物流开始回执：【发货单号: {},物流方式：{}, 物流单号：{}】", ecpDeliveryReceipt.getOrderno()
                , ecpDeliveryReceipt.getExpresscode(), ecpDeliveryReceipt.getExpressno());
	    httpClient.AddParam("content", JSON.toJSONString(ecpDeliveryReceipt));
	    if (httpClient.DoPost() == true) {
	        ecpResponse.setStatus(1);
	        ecpResponse.setMsg(httpClient.GetResponse());
	    } else {
	        ecpResponse.setStatus(0);
	        ecpResponse.setMsg(httpClient.GetLastError());
	    }
		log.info("物流回执结果：【发货单号: {}, {}】", ecpDeliveryReceipt.getOrderno(), JSON.toJSONString(ecpResponse));
	    return ecpResponse;
	}
	public static String getEcpExpressType(int  expressType) {
		String res;
		switch (expressType) {
			case 1:
				res = "门店";
				break;
			case 2:
				res = "FEDEX";
				break;
			case 3:
				res = "SF";
				break;
			case 4:
				res = "SF";
				break;
			case 5:
				res = "YTO";
				break;
			case 6:
				res = "德邦";
				break;
			case 7:
				res = "顺丰(海淘)";
				break;
			case 8:
				res = "OTHER";
				break;
			case 9:
				res = "ZTO";
				break;
			case  10:
				res = "OTHER";
				break;
			case  11:
				res = "OTHER";
				break;
			case  12:
				res = "SF";
				break;
			case 16:
				res = "JD";
				break;
			case 17:
				res = "JD";
				break;
            case 19:
                res = "SF";
                break;
            case 20:
                res = "POSTB";
                break;
            case 21:
                res = "EMS";
                break;
			default:
				res = "";
				break;
		}

		return res;
	}

}
