/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.rocketmq.springboot;

import com.thebeastshop.kit.rocketmq.RClient;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"rocketmq.name-server"})
public class RocketMQAutoConfiguration {
    @Resource
    private RocketMQTemplate rocketMQTemplate;

    @Bean
    public RClient rClient(Environment environment) {
        RClient rClient = RClient.getClient(this.rocketMQTemplate);
        String sendMessageTimeout = environment.getProperty("rocketmq.producer.send-message-timeout", "3000");
        long timeout = Long.parseLong(sendMessageTimeout);
        rClient.setDefaultSendMessageTimeout(timeout);
        return rClient;
    }
}

