/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.rocketmq;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

public class RTopicInvoker {
    private final Method method;

    public RTopicInvoker(Class paramType, Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getInvokeArguments(MessageExt message) {
        String text = new String(message.getBody());
        String tags = message.getTags();
        Class<?>[] paramTypes = this.method.getParameterTypes();
        Parameter[] parameters = this.method.getParameters();
        Object[] results = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Object obj;
            Class<?> type = paramTypes[i];
            Parameter param = parameters[i];
            if (CharSequence.class.isAssignableFrom(type)) {
                if ("tags".equals(param.getName())) {
                    results[i] = tags;
                    continue;
                }
                results[i] = text;
                continue;
            }
            if (Map.class.isAssignableFrom(type)) {
                if ("tags".equals(param.getName())) {
                    HashMap<String, Object> tagsMap = new HashMap<String, Object>();
                    if (StringUtils.isNotEmpty((CharSequence)tags)) {
                        String[] tagsGroup;
                        for (String tag : tagsGroup = tags.split("\\|\\|")) {
                            String[] tagNV = tag.trim().split(":", 2);
                            if (tagNV.length > 1) {
                                tagsMap.put(tagNV[0].trim(), tagNV[1].trim());
                                continue;
                            }
                            tagsMap.put(tagNV[0].trim(), true);
                        }
                    }
                    results[i] = tagsMap;
                    continue;
                }
                JSONObject map = JSON.parseObject((String)text);
                results[i] = map;
                continue;
            }
            results[i] = Message.class.isAssignableFrom(type) ? message : (obj = JSON.parseObject((String)text, type));
        }
        return results;
    }

    public Object invoke(Object instance, MessageExt message) throws InvocationTargetException, IllegalAccessException {
        Object[] args = this.getInvokeArguments(message);
        Method method = this.getMethod();
        return method.invoke(instance, args);
    }
}

