/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.rocketmq;

import java.util.concurrent.TimeUnit;

public enum RDelay {
    TIME_1_SECONDS(1, 1, TimeUnit.SECONDS),
    TIME_5_SECONDS(2, 5, TimeUnit.SECONDS),
    TIME_10_SECONDS(3, 10, TimeUnit.SECONDS),
    TIME_30_SECONDS(4, 30, TimeUnit.SECONDS),
    TIME_1_MINUTES(5, 1, TimeUnit.MINUTES),
    TIME_2_MINUTES(6, 2, TimeUnit.MINUTES),
    TIME_3_MINUTES(7, 3, TimeUnit.MINUTES),
    TIME_4_MINUTES(8, 4, TimeUnit.MINUTES),
    TIME_5_MINUTES(9, 5, TimeUnit.MINUTES),
    TIME_6_MINUTES(10, 6, TimeUnit.MINUTES),
    TIME_7_MINUTES(11, 7, TimeUnit.MINUTES),
    TIME_8_MINUTES(12, 8, TimeUnit.MINUTES),
    TIME_9_MINUTES(13, 9, TimeUnit.MINUTES),
    TIME_10_MINUTES(14, 10, TimeUnit.MINUTES),
    TIME_20_MINUTES(15, 20, TimeUnit.MINUTES),
    TIME_30_MINUTES(16, 30, TimeUnit.MINUTES),
    TIME_1_HOURS(17, 1, TimeUnit.HOURS),
    TIME_2_HOURS(18, 2, TimeUnit.HOURS);

    private final int timeLevel;
    private final int duration;
    private final TimeUnit timeUnit;
    private static final RDelay[] DELAY_CACHE;

    private RDelay(int timeLevel, int duration, TimeUnit timeUnit) {
        this.timeLevel = timeLevel;
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public int getTimeLevel() {
        return this.timeLevel;
    }

    public int getDuration() {
        return this.duration;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public static RDelay getByTimeLevel(int timeLevel) {
        if (timeLevel > 17) {
            timeLevel = 17;
        }
        if (timeLevel < 0) {
            timeLevel = 0;
        }
        return DELAY_CACHE[timeLevel];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.duration);
        switch (this.timeUnit) {
            case SECONDS: {
                builder.append("\u79d2");
                break;
            }
            case MINUTES: {
                builder.append("\u5206\u949f");
                break;
            }
            case HOURS: {
                builder.append("\u5c0f\u65f6");
            }
        }
        return builder.toString();
    }

    public static String timeLevelToString(int timeLevel) {
        RDelay delay;
        if (timeLevel > 0 && (delay = RDelay.getByTimeLevel(timeLevel)) != null) {
            return delay.toString();
        }
        return "";
    }

    static {
        DELAY_CACHE = new RDelay[]{TIME_1_SECONDS, TIME_5_SECONDS, TIME_10_SECONDS, TIME_30_SECONDS, TIME_1_MINUTES, TIME_2_MINUTES, TIME_3_MINUTES, TIME_4_MINUTES, TIME_5_MINUTES, TIME_6_MINUTES, TIME_7_MINUTES, TIME_8_MINUTES, TIME_9_MINUTES, TIME_10_MINUTES, TIME_20_MINUTES, TIME_30_MINUTES, TIME_1_HOURS, TIME_2_HOURS};
    }
}

