package com.thebeastshop.kit.rocketmq;

import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;

public class RTopicInvoker {

    private final Method method;


    public RTopicInvoker(Class paramType, Method method) {
        this.method = method;
    }


    public Method getMethod() {
        return method;
    }

    public Object[] getInvokeArguments(final MessageExt message) {
        final String text = new String(message.getBody());
        final String tags = message.getTags();
        Class[] paramTypes = method.getParameterTypes();
        Parameter[] parameters = method.getParameters();
        Object[] results = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; i++) {
            final Class type = paramTypes[i];
            final Parameter param = parameters[i];
            if (CharSequence.class.isAssignableFrom(type)) {
                if ("tags".equals(param.getName())) {
                    results[i] = tags;
                } else {
                    results[i] = text;
                }
            } else if (Map.class.isAssignableFrom(type)) {
                if ("tags".equals(param.getName())) {
                    Map<String, Object> tagsMap = new HashMap<>();
                    if (StringUtils.isNotEmpty(tags)) {
                        String[] tagsGroup = tags.split("\\|\\|");
                        for (String tag : tagsGroup) {
                            String[] tagNV = tag.trim().split(":", 2);
                            if (tagNV.length > 1) {
                                tagsMap.put(tagNV[0].trim(), tagNV[1].trim());
                            } else {
                                tagsMap.put(tagNV[0].trim(), true);
                            }
                        }
                    }
                    results[i] = tagsMap;
                } else {
                    Map<String, Object> map = JSON.parseObject(text);
                    results[i] = map;
                }
            } else if (Message.class.isAssignableFrom(type)) {
                results[i] = message;
            } else {
                Object obj = JSON.parseObject(text, type);
                results[i] = obj;
            }
        }
        return results;
    }

    public Object invoke(final Object instance, final MessageExt message)
            throws InvocationTargetException, IllegalAccessException {
        final Object[] args = getInvokeArguments(message);
        final Method method = getMethod();
        return method.invoke(instance, args);
    }

}
