/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.redis.springboot;

import com.thebeastshop.kit.redis.lock.RedisDistributLock;
import com.thebeastshop.kit.redis.script.RedisScriptScanner;
import com.thebeastshop.kit.redis.util.RedisClient;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"redis.sentinel.address"})
public class RedisAutoConfiguration {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String REDIS_MASTER_NAME = "redis.master.name";
    private static final String REDIS_SENTINEL_ADDRESS = "redis.sentinel.address";
    private static final String REDIS_ADDRESS = "redis.address";
    private static final String REDIS_PASSWORD = "redis.password";
    private static final String REDIS_DBINDEX = "redis.dbindex";
    private static final String REDIS_MASTER_MIN_IDLE_SIZE = "redis.master.min.idle.size";
    private static final String REDIS_MASTER_POOL_SIZE = "redis.master.pool.size";
    private static final String REDIS_SLAVE_POOL_SIZE = "redis.slave.pool.size";
    private static final String REDIS_SLAVE_MIN_IDLE_SIZE = "redis.slave.min.idle.size";
    private static final String REDIS_NETTY_THREAD = "redis.netty.thread";

    @Bean
    public RedissonClient redissonClient(Environment environment) {
        this.log.info("\u5f00\u59cbredis\u7684\u81ea\u52a8\u521d\u59cb\u5316,\u5730\u5740\u4e3a{}", (Object)environment.getProperty(REDIS_ADDRESS));
        Config config = new Config();
        if (environment.containsProperty(REDIS_NETTY_THREAD)) {
            config.setNettyThreads(Integer.parseInt(environment.getProperty(REDIS_NETTY_THREAD, "32")));
        }
        ((SingleServerConfig)config.useSingleServer().setAddress(environment.getProperty(REDIS_SENTINEL_ADDRESS)).setPassword(environment.getProperty(REDIS_PASSWORD))).setDatabase(((Integer)environment.getProperty(REDIS_DBINDEX, Integer.class, (Object)0)).intValue()).setConnectionPoolSize(((Integer)environment.getProperty(REDIS_MASTER_POOL_SIZE, Integer.class, (Object)64)).intValue()).setConnectionMinimumIdleSize(((Integer)environment.getProperty(REDIS_MASTER_MIN_IDLE_SIZE, Integer.class, (Object)10)).intValue());
        return Redisson.create((Config)config);
    }

    @Bean
    public RedisClient redisClient(RedissonClient redissonClient) {
        RedisClient redisClient = new RedisClient(redissonClient);
        return redisClient;
    }

    @Bean
    public RedisDistributLock redisDistributLock(RedissonClient redissonClient) {
        RedisDistributLock redisDistributLock = new RedisDistributLock(redissonClient);
        return redisDistributLock;
    }

    @Bean
    public RedisScriptScanner redisScriptScanner(RedissonClient redissonClient) {
        RedisScriptScanner redisScriptScanner = new RedisScriptScanner(redissonClient, "classpath*:lua/*.lua");
        return redisScriptScanner;
    }
}

