package com.thebeastshop.kit.redis.springboot;

import com.thebeastshop.kit.redis.lock.RedisDistributLock;
import com.thebeastshop.kit.redis.script.RedisScriptScanner;
import com.thebeastshop.kit.redis.util.RedisClient;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * @author Bryan.Zhang
 * @Date 2019-03-20
 */
@Configuration
@ConditionalOnProperty(name = "redis.sentinel.address")
public class RedisAutoConfiguration {

    private final Logger log = LoggerFactory.getLogger(getClass());

    private final static String REDIS_MASTER_NAME = "redis.master.name";
    private final static String REDIS_SENTINEL_ADDRESS = "redis.sentinel.address";
    private final static String REDIS_ADDRESS = "redis.address";
    private final static String REDIS_PASSWORD = "redis.password";
    private final static String REDIS_DBINDEX = "redis.dbindex";
    private final static String REDIS_MASTER_MIN_IDLE_SIZE = "redis.master.min.idle.size";
    private final static String REDIS_MASTER_POOL_SIZE = "redis.master.pool.size";
    private final static String REDIS_SLAVE_POOL_SIZE = "redis.slave.pool.size";
    private final static String REDIS_SLAVE_MIN_IDLE_SIZE = "redis.slave.min.idle.size";
    private final static String REDIS_NETTY_THREAD = "redis.netty.thread";

    @Bean
    public RedissonClient redissonClient(Environment environment){
        log.info("开始redis的自动初始化,地址为{}",environment.getProperty(REDIS_ADDRESS));
        Config config = new Config();
        if(environment.containsProperty(REDIS_NETTY_THREAD)){
            config.setNettyThreads(Integer.parseInt(environment.getProperty(REDIS_NETTY_THREAD,"32")));
        }
        config.useSingleServer().setAddress(environment.getProperty(REDIS_SENTINEL_ADDRESS))
                        .setPassword(environment.getProperty(REDIS_PASSWORD))
                        .setDatabase(environment.getProperty(REDIS_DBINDEX,Integer.class,0))
                        .setConnectionPoolSize(environment.getProperty(REDIS_MASTER_POOL_SIZE,Integer.class,64))
                        .setConnectionMinimumIdleSize(environment.getProperty(REDIS_MASTER_MIN_IDLE_SIZE,Integer.class,10));
        return Redisson.create(config);
    }

    @Bean
    public RedisClient redisClient(RedissonClient redissonClient){
        RedisClient redisClient = new RedisClient(redissonClient);
        return redisClient;
    }

    @Bean
    public RedisDistributLock redisDistributLock(RedissonClient redissonClient){
        RedisDistributLock redisDistributLock = new RedisDistributLock(redissonClient);
        return redisDistributLock;
    }

    @Bean
    public RedisScriptScanner redisScriptScanner(RedissonClient redissonClient){
        RedisScriptScanner redisScriptScanner = new RedisScriptScanner(redissonClient,"classpath*:lua/*.lua");
        return redisScriptScanner;
    }

}
