/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.prop.springboot;

import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.kit.prop.PropPropertiesSource;
import java.util.Map;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;

public class PropContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext context) {
        ConfigurableEnvironment environment = context.getEnvironment();
        this.initializeSystemProperty(environment);
    }

    public static boolean matchLocalPropertySource(PropertySource source) {
        return source.getName().startsWith("applicationConfig:") || source.getName().startsWith("Config resource 'class path resource");
    }

    void initializeSystemProperty(ConfigurableEnvironment environment) {
        if (!environment.getPropertySources().contains("PropBootstrapPropertySources")) {
            CompositePropertySource composite = new CompositePropertySource("PropBootstrapPropertySources");
            composite.addPropertySource((PropertySource)new PropPropertiesSource("PropSource"));
            environment.getPropertySources().addFirst((PropertySource)composite);
        }
        PropConfig config = PropConfig.getInstance();
        for (PropertySource source : environment.getPropertySources()) {
            if (!PropContextInitializer.matchLocalPropertySource(source)) continue;
            if (PropConfig.getEnv().equals("local")) {
                config.mergeLocalConfigSource((Map)source.getSource());
                config.printAllProperties();
            } else {
                environment.getPropertySources().remove(source.getName());
            }
            return;
        }
    }
}

