package com.thebeastshop.kit.prop;

import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.google.common.collect.Lists;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-07-07 14:04
 */
public class ApolloPropChangeEvent implements PropChangeEvent {

    private ConfigChangeEvent event;

    private Map<String, PropChange> changeMap = new HashMap<>();

    public ApolloPropChangeEvent(ConfigChangeEvent event) {
        this.event = event;
    }

    @Override
    public String getNamespace() {
        return event.getNamespace();
    }

    @Override
    public List<String> getPropNames() {
        return Lists.newArrayList(event.changedKeys());
    }

    @Override
    public PropChange getChange(String propName) {
        PropChange propChange = changeMap.get(propName);
        if (propChange != null) {
            return propChange;
        }
        ConfigChange configChange = event.getChange(propName);
        if (configChange == null) {
            return null;
        }
        PropertyChangeType changeType = configChange.getChangeType();
        String namespace = configChange.getNamespace();
        String newValue = configChange.getNewValue();
        String oldValue = configChange.getOldValue();
        String name = configChange.getPropertyName();
        PropChangeType propChangeType = PropChangeType.valueOf(changeType.name());
        propChange = new PropChange(propChangeType, namespace, name, newValue, oldValue);
        changeMap.put(propName, propChange);
        return propChange;
    }
}
