package com.thebeastshop.kit.prop.springboot;

import com.ctrip.framework.apollo.spring.annotation.SpringValueProcessor;
import com.ctrip.framework.apollo.spring.property.SpringValueDefinitionProcessor;
import com.ctrip.framework.apollo.spring.util.BeanRegistrationUtil;
import com.thebeastshop.kit.prop.PropAnnotationProcessor;
import com.thebeastshop.kit.prop.PropConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

import java.util.Iterator;
import java.util.Map;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2019-03-06 17:47
 */
public class PropConstantsProcessor implements BeanFactoryPostProcessor, EnvironmentAware, PriorityOrdered, BeanDefinitionRegistryPostProcessor {

    private ConfigurableEnvironment environment;

    @Override
    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropertySourcesPlaceholderConfigurer.class.getName(), PropertySourcesPlaceholderConfigurer.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, PropAnnotationProcessor.class.getName(), PropAnnotationProcessor.class);
        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, SpringValueProcessor.class.getName(), SpringValueProcessor.class);
//        BeanRegistrationUtil.registerBeanDefinitionIfNotExists(registry, ApolloJsonValueProcessor.class.getName(), ApolloJsonValueProcessor.class);
        this.processSpringValueDefinition(registry);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        PropConfig config = PropConfig.getInstance();
        Iterator<PropertySource<?>> iterator = environment.getPropertySources().iterator();
        for (; iterator.hasNext(); ) {
            PropertySource source = iterator.next();
            if (source.getName().startsWith("applicationConfig:")) {
                if (PropConfig.getEnv().equals(PropConfig.ENV_LOCAL)) {
                    config.mergeLocalConfigSource((Map<?, ?>) source.getSource());
                    config.printAllProperties();
                } else {
                    environment.getPropertySources().remove(source.getName());
                }
                return;
            }
        }
    }

    private void processSpringValueDefinition(BeanDefinitionRegistry registry) {
        SpringValueDefinitionProcessor springValueDefinitionProcessor = new SpringValueDefinitionProcessor();
        springValueDefinitionProcessor.postProcessBeanDefinitionRegistry(registry);
    }

    @Override
    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment) environment;
    }

    @Override
    public int getOrder() {
        return -2147483648;
    }
}
