package com.thebeastshop.kit.prop.annotation;

import com.thebeastshop.kit.prop.PropConstants;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-07-07 17:27
 */
public class DynamicPropAccessor {

    private String propName;

    private Object bean;

    private Field field;

    private Class fieldType;

    public DynamicPropAccessor(String propName, Object bean, Field field) {
        this.propName = propName;
        this.bean = bean;
        this.field = field;
        this.fieldType = field.getType();
    }

    private Object convertFieldValue(String newValue) {
        if (newValue == null) {
            return null;
        }
        if (CharSequence.class.isAssignableFrom(fieldType)) {
            return newValue;
        }
        if (byte.class.isAssignableFrom(fieldType) || Byte.class.isAssignableFrom(fieldType)) {
            return Byte.parseByte(newValue);
        }
        if (char.class.isAssignableFrom(fieldType)) {
            return newValue.charAt(0);
        }
        if (boolean.class.isAssignableFrom(fieldType) || Boolean.class.isAssignableFrom(fieldType)) {
            return Boolean.parseBoolean(newValue);
        }
        if (int.class.isAssignableFrom(fieldType) || Integer.class.isAssignableFrom(fieldType)) {
            return Integer.parseInt(newValue);
        }
        if (short.class.isAssignableFrom(fieldType) || Short.class.isAssignableFrom(fieldType)) {
            return Short.parseShort(newValue);
        }
        if (long.class.isAssignableFrom(fieldType) || Long.class.isAssignableFrom(fieldType)) {
            return Long.parseLong(newValue);
        }
        if (float.class.isAssignableFrom(fieldType) || Float.class.isAssignableFrom(fieldType)) {
            return Float.parseFloat(newValue);
        }
        if (double.class.isAssignableFrom(fieldType) || Double.class.isAssignableFrom(fieldType)) {
            return Double.parseDouble(newValue);
        }
        return newValue;
    }

    public synchronized void refreshValue() {
        String newValue = PropConstants.getProperties(propName);
        Object val = convertFieldValue(newValue);
        ReflectionUtils.setField(field, bean, val);
    }
}
