package com.thebeastshop.kit.prop.springboot;

import com.thebeastshop.kit.prop.PropAnnotationProcessor;
import com.thebeastshop.kit.prop.PropConfig;
import com.thebeastshop.kit.prop.PropConstants;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PropAutoConfiguration {
    @Bean
    public PropConstants propConstants(){
        Boolean ignoreUnresolvablePlaceholders = PropConfig.getProperties("beastkit.prop.ignoreUnresolvablePlaceholders",Boolean.class);
        PropConstants propConstants = new PropConstants();
        if(ignoreUnresolvablePlaceholders!=null){
            propConstants.setIgnoreUnresolvablePlaceholders(ignoreUnresolvablePlaceholders);
        }
        return propConstants;
    }

    @Bean
    public PropConstantsProcessor propConstantsProcessor(){
        return new PropConstantsProcessor();
    }

    @Bean
    public PropAnnotationProcessor propAnnotationProcessor(){
        return new PropAnnotationProcessor();
    }
}
