package com.thebeastshop.kit.prop.annotation;

import java.lang.annotation.*;

/**
 * 动态配置属性更新事件注解<BR/>
 * 当Apollo配置中心Value对应的属性值发送改变时<BR/>
 * 便会自动调用该注解所标注的方法
 *
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-07-07 16:57
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
@Documented
public @interface PropOnChange {

    /**
     * 属性名称
     * @return
     */
    String value();
}
