package com.thebeastshop.kit.prop.annotation;

import java.lang.annotation.*;

/**
 * 动态配置属性值注解 <br/>
 * 加了该注解的Field<br/>
 * 会动态地自动更新配置中心上的最新数据<BR/>
 * <BR/>
 * <B>注意：</B><br/>
 * 1. 作用范围只能在spring容器中初始化的类的字段<br/>
 * 3. 字段不能是<B>static</B>的<br/>
 * 2. 字段可以是任何访问限制的修饰符，包括 <B>private</B>
 *
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-07-07 16:56
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
@Documented
public @interface DynamicPropValue {
    String value();
}
