package com.thebeastshop.kit.prop;

import com.thebeastshop.kit.prop.annotation.DynamicPropAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import java.util.List;
import java.util.Properties;

public class PropConstants extends PropertySourcesPlaceholderConfigurer {

	private static final Logger log = LoggerFactory.getLogger(PropConstants.class);

	public static final String ENV_LOCAL = "local";

	public static final String ENV_TEST = "test";

	public static final String ENV_PRE = "pre";

	public static final String ENV_PROD = "prod";


	public PropConstants() {
		super();
		log.info("init PropConstants");
	}

	/**
	 * 获取resources/META-INF/app.properties中的配置信息
	 * @param name
	 * @return
     */
	public static String getMetaAppProperty(String name) {
		return PropConfig.getMetaAppProperty(name);
	}

	/**
	 * 添加属性匹配处理器
	 * @param patternProcessor
	 */
	public static void addPatternProcessor(PropPatternProcessor patternProcessor) {
		PropConfig.addPatternProcessor(patternProcessor);
	}

	/**
	 * 获取当前App的ID
	 * @return
     */
	public static String getAppId() {
		return PropConfig.getAppId();
	}


	public static String getProperties(String key){
		return PropConfig.getProperties(key);
	}

	public static <T> T getProperties(String key, Class<T> clazz){
		return PropConfig.getProperties(key,clazz);
	}

	public static <T> List<T> getListProperties(String key, Class<T> clazz){
		return PropConfig.getListProperties(key, clazz);
	}

	public static Integer getIntProperties(String key){
		return PropConfig.getProperties(key,Integer.class);
	}

	public static String getProperties(String key, String defaultValue) {
		return PropConfig.getProperties(key, defaultValue);
	}

	public static Object setProperties(String key, String value) {
		return PropConfig.setProperties(key, value);
	}


	/**
	 * 获取运行环境
	 * @return
     */
	public static String getEnv(Properties properties) {
		return PropConfig.getEnv(properties);
	}

	public String getProperty(String key) {
		return PropConfig.getProperties(key);
	}

	public String getProperty(String key, String defaultValue) {
		return PropConfig.getProperties(key, defaultValue);
	}

	public Object setProperty(String key, String value) {
		return PropConfig.getProperties(key, value);
	}

	public static Properties getPropertiesObj(){
		return PropConfig.getPropertiesObj();
	}


	public PropConstants addPropertiesChangeCallback(String namespace, String propName, PropChangeCallback callback) {
		return addPropertiesChangeCallback("default", namespace, propName, callback);
	}

	public PropConstants addPropertiesChangeCallback(String beanId, String namespace, String propName, PropChangeCallback callback) {
		PropConfig.addPropChangeCallback(beanId, propName, callback);
		return this;
	}

	static void registerPropAccessor(String beanId, String propName, DynamicPropAccessor accessor) {
		PropConfig.registerPropAccessor(beanId, propName, accessor);
	}


	public static void addPropChangeCallback(String beanId, String propName, PropChangeCallback callback) {
		PropConfig.addPropChangeCallback(beanId, propName, callback);
	}

	public static void addPropChangeCallback(String propName, PropChangeCallback callback) {
		PropConfig.addPropChangeCallback(propName, callback);
	}

}
