/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.kafka.springboot;

import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.kit.kafka.springboot.KafkaConsumerStarter;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnProperty(name={"kafka.bootstrap.servers"})
public class KafkaAutoConfiguration {
    private static final String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";
    private static final String KAFKA_AUTO_FLUSH = "kafka.send-auto-flush";
    private static final String KAFKA_INIT_ADMINCLIENT = "kafka.init.adminclient";
    private static final String KAFKA_DEFAULT_TOPIC = "kafka.default.topic";

    @Bean
    public KafkaDriver kafkaDriver(Environment environment) {
        boolean autoFlush = Boolean.parseBoolean(environment.getProperty(KAFKA_AUTO_FLUSH, "false"));
        boolean initAdminclient = Boolean.parseBoolean(environment.getProperty(KAFKA_INIT_ADMINCLIENT, "false"));
        String bootstrapServers = environment.getProperty(KAFKA_BOOTSTRAP_SERVERS);
        KafkaDriver kafkaDriver = KafkaDriver.drive(bootstrapServers, autoFlush, initAdminclient);
        String defaultTopic = environment.getProperty(KAFKA_DEFAULT_TOPIC);
        if (StringUtils.isNotBlank((CharSequence)defaultTopic)) {
            kafkaDriver.setDefaultTopic(defaultTopic);
        }
        return kafkaDriver;
    }

    @Bean
    public KafkaProducerClient kafkaProducerClient(KafkaDriver kafkaDriver) {
        return new KafkaProducerClient(kafkaDriver.getKafkaTemplate());
    }

    @Bean
    public KafkaConsumerStarter kafkaConsumerStarter(KafkaDriver kafkaDriver) {
        return new KafkaConsumerStarter(kafkaDriver);
    }
}

