package com.thebeastshop.kit.kafka.serialization;

import com.thebeastshop.common.ByteHandler;
import org.apache.kafka.common.serialization.Serializer;

import java.util.Map;

/**
 * 序列化器
 *
 * @author Paul-xiong
 * @date 2018年8月7日
 * @description
 */
public class KafkaSerializer implements Serializer<Object> {

	@Override
	public void configure(Map<String, ?> configs, boolean isKey) {

	}

	@Override
	public byte[] serialize(String topic, Object data) {
		if (!(data instanceof ByteHandler)) {
			throw new RuntimeException("need to implement ByteSerializer");
		}
		return ((ByteHandler) data).toByteArray();
	}

	@Override
	public void close() {

	}

}
