package com.thebeastshop.kit.kafka.producer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

import java.util.Date;
import java.util.List;

/**
 * Kafka生产者客户端
 */
@SuppressWarnings(value={"unchecked", "rawtypes"})
public class KafkaProducerClient {

	private KafkaTemplate kafkaTemplate;

//	private ExecutorService threadPool = Executors.newFixedThreadPool(20);


	public KafkaProducerClient(KafkaTemplate kafkaTemplate) {
		this.kafkaTemplate = kafkaTemplate;
	}

	public KafkaProducerClient() {
	}

	public void send(Object t){
		send(kafkaTemplate.getDefaultTopic(), t);
	}

	public void send(String topic, Object t){
		send(topic, null, t, false, null);
	}

	public void send(String topic, String key, Object t){
		send(topic, key, t, false, null);
	}

	public void send(String topic, List<?> list){
		for(Object t : list){
			send(topic, t);
		}
	}

	public void sendWithCallback(String topic, Object t, ListenableFutureCallback<SendResult<String, String>> callback){
		send(topic, null, t, false, callback);
	}

	public void sendWithCallback(String topic, String key, Object t, ListenableFutureCallback<SendResult<String, String>> callback){
		send(topic, key, t, false, callback);
	}

	public void sendWithClass(Object t){
		sendWithClass(kafkaTemplate.getDefaultTopic(), t);
	}

	public void sendWithClass(String topic, Object t){
		send(topic, null, t, true, null);
	}

	public void sendWithClass(String topic, String key, Object t){
		send(topic, key, t, true, null);
	}

	public void sendWithClass(String topic, List<?> list){
		for(Object t : list){
			sendWithClass(topic, t);
		}
	}

	public void sendWithClassAndCallback(String topic, Object t, ListenableFutureCallback<SendResult<String, String>> callback){
		send(topic, null, t, true, callback);
	}

	public void sendWithClassAndCallback(String topic, String key, Object t, ListenableFutureCallback<SendResult<String, String>> callback){
		send(topic, key, t, true, callback);
	}

	/**
	 * 发送消息
	 * @param topic 主题
	 * @param key  键
	 * @param t 消息
	 * @param writeClass 消息体是否带类元信息
	 * @param callback 回调函数
     */
	private void send(String topic, String key, Object t, boolean writeClass, ListenableFutureCallback callback){
		ListenableFuture future;
		if(writeClass){
			future = kafkaTemplate.send(topic, key, JSON.toJSONString(t,SerializerFeature.WriteClassName));
		}else{
			future = kafkaTemplate.send(topic, key, JSON.toJSONString(t));
		}

		if (callback != null){
			future.addCallback(callback);
		}
	}

	public KafkaTemplate getKafkaTemplate() {
		return kafkaTemplate;
	}

	public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
		this.kafkaTemplate = kafkaTemplate;
	}
}
