package com.thebeastshop.kit.kafka.springboot;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.thebeastshop.common.utils.MetaUtil;
import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.kit.prop.PropConstants;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.kafka.listener.MessageListener;

import java.util.List;

@Configuration
@ConditionalOnProperty(name = "kafka.bootstrap.servers")
public class KafkaAutoConfiguration {

    private final static String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";

    private final static String KAFKA_AUTO_FLUSH = "kafka.send-auto-flush";

    private final static String KAFKA_DEFAULT_TOPIC = "kafka.default.topic";

    @Bean
    public KafkaProducerClient kafkaProducerClient(Environment environment){
        boolean autoFlush = Boolean.parseBoolean(environment.getProperty(KAFKA_AUTO_FLUSH, "true"));
        String bootstrapServers = environment.getProperty(KAFKA_BOOTSTRAP_SERVERS);
        KafkaDriver kafkaDriver = KafkaDriver.drive(bootstrapServers, autoFlush);
        String defaultTopic = environment.getProperty(KAFKA_DEFAULT_TOPIC);

        if(StringUtils.isNotBlank(defaultTopic)){
            kafkaDriver.setDefaultTopic(defaultTopic);
        }
        return new KafkaProducerClient(kafkaDriver.getKafkaTemplate());
    }
}
