/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.kafka.producer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.util.concurrent.ListenableFuture;

public class KafkaProducerClient {
    private KafkaTemplate kafkaTemplate;

    public KafkaProducerClient(KafkaTemplate kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }

    public KafkaProducerClient() {
    }

    public <T> boolean send(T t) {
        return this.send(this.kafkaTemplate.getDefaultTopic(), t);
    }

    public <T> boolean sendWithClass(T t) {
        return this.sendWithClass(this.kafkaTemplate.getDefaultTopic(), t);
    }

    public <T> boolean send(String topic, T t) {
        return this.send(topic, null, t, false);
    }

    public <T> boolean sendWithClass(String topic, T t) {
        return this.send(topic, null, t, true);
    }

    public <T> void send(String topic, List<T> list) {
        for (T t : list) {
            this.send(topic, t);
        }
    }

    public <T> void sendWithClass(String topic, List<T> list) {
        for (T t : list) {
            this.sendWithClass(topic, t);
        }
    }

    public <T> boolean send(String topic, String key, T t, boolean writeClass) {
        ListenableFuture future = writeClass ? this.kafkaTemplate.send(topic, (Object)key, (Object)JSON.toJSONString(t, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName})) : this.kafkaTemplate.send(topic, (Object)key, (Object)JSON.toJSONString(t));
        return future.isDone();
    }

    public KafkaTemplate getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    public void setKafkaTemplate(KafkaTemplate kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
    }
}

