/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.kit.kafka.springboot;

import com.thebeastshop.kit.kafka.producer.KafkaProducerClient;
import com.thebeastshop.kit.kafka.springboot.KafkaConsumerStarter;
import com.thebeastshop.kit.kafka.utils.KafkaDriver;
import com.thebeastshop.kit.prop.PropConstants;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"kafka.bootstrap.servers"})
public class KafkaAutoConfiguration {
    private static final String KAFKA_BOOTSTRAP_SERVERS = "kafka.bootstrap.servers";

    @Bean
    public KafkaProducerClient kafkaProducerClient() {
        KafkaDriver kafkaDriver = KafkaDriver.drive(PropConstants.getProperties((String)KAFKA_BOOTSTRAP_SERVERS));
        KafkaProducerClient kafkaProducerClient = new KafkaProducerClient(kafkaDriver.getKafkaTemplate());
        return kafkaProducerClient;
    }

    @Bean
    public KafkaConsumerStarter kafkaConsumerStarter() {
        return new KafkaConsumerStarter();
    }
}

