/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    public static String toXml(Object obj) throws Exception {
        String xml = "";
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = context.createMarshaller();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        marshaller.marshal(obj, (OutputStream)os);
        xml = os.toString("utf-8");
        return xml;
    }

    public static <T> T toObject(String xml, Class<T> clazz) throws Exception {
        Object obj = null;
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        byte[] buf = xml.getBytes("UTF-8");
        obj = unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(buf));
        return (T)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String xmlToString(InputStreamReader in) {
        BufferedReader reader = new BufferedReader(in);
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\r\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String xmlToString(InputStream in) {
        String responseString = null;
        BufferedInputStream bis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int count;
            bis = new BufferedInputStream(in);
            byte[] bytes = new byte[1024];
            while ((count = bis.read(bytes)) != -1) {
                bos.write(bytes, 0, count);
            }
            byte[] strByte = bos.toByteArray();
            responseString = new String(strByte, 0, strByte.length, "utf-8");
        }
        catch (IOException e) {
            try {
                bos.close();
                bis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return responseString;
    }

    public static <T> T fromXML(String xml, Class<T> valueType) throws JAXBException {
        Object message = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{valueType});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader sr = new StringReader(xml);
            message = unmarshaller.unmarshal((Reader)sr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return (T)message;
    }

    public static String parseString(String express, String xml) throws XPathExpressionException {
        if (StringUtils.isNotBlank((CharSequence)xml)) {
            XPath xPath = XmlUtil.getXPath();
            return (String)xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.STRING);
        }
        return null;
    }

    public static NodeList parseNodeList(String express, String xml) throws XPathExpressionException {
        if (StringUtils.isNotBlank((CharSequence)xml)) {
            XPath xPath = XmlUtil.getXPath();
            return (NodeList)xPath.evaluate(express, new InputSource(new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8))), XPathConstants.NODESET);
        }
        return null;
    }

    public static XPath getXPath() {
        return XPathFactory.newInstance().newXPath();
    }

    public static <T> List<T> getObjecList(String filePath, Class<T> clazz, String childNote) throws Exception {
        Document doc = null;
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            SAXReader reader = new SAXReader();
            doc = reader.read(new File(filePath));
            Element rootElt = doc.getRootElement();
            Iterator it = rootElt.elementIterator(childNote);
            while (it.hasNext()) {
                Element elementGroupService = (Element)it.next();
                Object baseBean = XmlUtil.fromXmlToBean(elementGroupService, clazz);
                list.add(baseBean);
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static Object fromXmlToBean(Element rootElt, Class clazz) throws Exception {
        Field[] fields = clazz.getDeclaredFields();
        Object obj = clazz.newInstance();
        try {
            for (Field field : fields) {
                field.setAccessible(true);
                String name = field.getName();
                rootElt.elementTextTrim(name);
                if (rootElt.elementTextTrim(name) == null || "".equals(rootElt.elementTextTrim(name))) continue;
                if (field.getType().equals(Long.class) || field.getType().equals(Long.TYPE)) {
                    field.set(obj, Long.parseLong(rootElt.elementTextTrim(name)));
                    continue;
                }
                if (field.getType().equals(String.class)) {
                    field.set(obj, rootElt.elementTextTrim(name));
                    continue;
                }
                if (field.getType().equals(Double.class) || field.getType().equals(Double.TYPE)) {
                    field.set(obj, Double.parseDouble(rootElt.elementTextTrim(name)));
                    continue;
                }
                if (field.getType().equals(Integer.class) || field.getType().equals(Integer.TYPE)) {
                    field.set(obj, Integer.parseInt(rootElt.elementTextTrim(name)));
                    continue;
                }
                if (!field.getType().equals(Date.class)) continue;
                field.set(obj, Date.parse(rootElt.elementTextTrim(name)));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return obj;
    }
}

