package com.thebeastshop.common.cat;

import com.dianping.cat.Cat;
import com.thebeastshop.kit.prop.PropConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class CatEnableInit implements InitializingBean {

    private final String propName = "cat_enabled";

    @Override
    public void afterPropertiesSet() throws Exception {
        String catEnabled = PropConfig.getProperties(propName, "true");
        if (Boolean.parseBoolean(catEnabled)){
            Cat.enable();
        }else{
            Cat.disable();
        }

        PropConfig.addPropChangeCallback(propName, propChange -> {
            if (StringUtils.isNotBlank(propChange.getNewValue())){
                boolean enabled = Boolean.parseBoolean(propChange.getNewValue());
                if (enabled){
                    Cat.enable();
                }else{
                    Cat.disable();
                }
            }
        });
    }
}
