package com.thebeastshop.common.converter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;

/**
 * @author gongjun
 * @since 2016-10-17
 */
public abstract class AbstractBaseDomain<VO, PO> implements BaseDomain<VO, PO> {

    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    protected POVOConverter<VO, PO> converter;
    {
        initConverter();
        init();
    }

    @Override
    public Class<VO> getVOClass() {
        return converter.getVOClass();
    }

    @Override
    public Class<PO> getPOClass() {
        return converter.getPOClass();
    }

    public <T> ToList<T> from(Class<T> source) {
        return ConverterSupport.from(source);
    }


    public AbstractBaseDomain() {
    }

    protected <T> Class<T> getGenericClass(int index) {
        Type superClass = this.getClass().getGenericSuperclass();
        Type[] types = ((ParameterizedType)superClass).getActualTypeArguments();
        if (types.length - 1 < index) {
            return null;
        }
        Type type = types[index];
        if (type instanceof TypeVariable) {
            return (Class<T>) ((TypeVariable) type).getBounds()[0];
        }
        return (Class<T>) type;
    }


    private void initConverter() {
        converter = createConverter();
    }

    /**
     * 创建类型转换器
     * @return
     */
    protected POVOConverter<VO, PO> createConverter() {
        Class<VO> voClass = getGenericClass(0);
        Class<PO> poClass = getGenericClass(1);
        return new GenericPOVOConverter<VO, PO>(voClass, poClass);
    }

    protected void init() {
    }

    protected POVOConverter<VO, PO> getConverter() {
        return converter;
    }

    @Override
    public <T> T converterFrom(Object obj, Class<T> clazz) {
        return getConverter().converterFrom(obj, clazz);
    }

    @Override
    public <T> List<T> converterListFrom(List list, Class<T> clazz) {
        return getConverter().converterListFrom(list, clazz);
    }

    @Override
    public VO voFromPO(PO po) {
        return getConverter().voFromPO(po);
    }

    @Override
    public List<VO> voListFromPOList(List<PO> pos) {
        return getConverter().voListFromPOList(pos);
    }


    @Override
    public PO poFromVO(VO vo) {
        return getConverter().poFromVO(vo);
    }

    @Override
    public List<PO> poListFromVOList(List<VO> vos) {
        return getConverter().poListFromVOList(vos);
    }

    @Override
    public VO voFromObject(Object obj) {
        return getConverter().voFromObject(obj);
    }

    @Override
    public List<VO> voListFromList(List<?> list) {
        return getConverter().voListFromList(list);
    }

    @Override
    public PO poFromObject(Object obj) {
        return getConverter().poFromObject(obj);
    }

    @Override
    public List<PO> poListFromList(List<?> list) {
        return getConverter().poListFromList(list);
    }
}
