/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.converter.BeanConverterHandlerManager;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.GenericBeanConverter;
import com.thebeastshop.common.utils.EmptyUtil;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ConcurrentReferenceHashMap;

public class BeanUtil {
    private static final Set<Class<?>> primitiveSet = new HashSet();

    public static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }

    public static <T> T buildFrom(Object src, Class<T> clz) {
        T obj = BeanUtil.buildFroms(src, clz, null, false);
        return obj;
    }

    public static <T> T buildFrom(Object src, Class<T> clz, boolean deeply) {
        T obj = BeanUtil.buildFroms(src, clz, null, deeply);
        return obj;
    }

    public static <T> T buildFroms(Object src, Class<T> clazz, String[] ignoreProperties) {
        return BeanUtil.buildFroms(src, clazz, ignoreProperties, false);
    }

    public static <T> T buildFroms(Object src, Class<T> clazz, String[] ignoreProperties, boolean deeply) {
        if (src == null) {
            return null;
        }
        Object ret = null;
        try {
            ret = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class<?> fromClass = src.getClass();
        BeanConverterHandlerManager handlerManager = BeanUtil.matchHandlerManager(fromClass, clazz);
        String[] ignoreFields = ignoreProperties;
        if (handlerManager != null) {
            if (ignoreFields == null) {
                ignoreFields = handlerManager.getIgnoreFields();
            }
            GenericBeanConverter.copyProperties(src, ret, null, deeply, ignoreFields);
            handlerManager.afterCopyProperties(src, ret);
        } else {
            GenericBeanConverter.copyProperties(src, ret, null, deeply, ignoreFields);
        }
        BeanUtil.convertParameterizedTypeField(ret, deeply);
        return (T)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deepCopy(Object src, Class<T> clz) {
        if (src == null) {
            return null;
        }
        Object targetObj = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(src);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            targetObj = objectInputStream.readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (T)targetObj;
    }

    private static <T> void convertParameterizedTypeField(T obj, boolean deeply) {
        if (obj == null) {
            return;
        }
        try {
            for (Field f : obj.getClass().getDeclaredFields()) {
                ParameterizedType pt;
                Class accountPrincipalApproveClazz;
                Type genericType;
                if (f.getType() != List.class || (genericType = f.getGenericType()) == null || !(genericType instanceof ParameterizedType) || BeanUtil.isPrimitiveWrapper(accountPrincipalApproveClazz = (Class)(pt = (ParameterizedType)genericType).getActualTypeArguments()[0])) continue;
                f.setAccessible(true);
                List list = (List)f.get(obj);
                if (list == null) continue;
                List<T> returnList = BeanUtil.buildListFrom(list, accountPrincipalApproveClazz, deeply);
                f.set(obj, returnList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T> boolean isPrimitiveWrapper(Class<T> tClass) {
        return primitiveSet.contains(tClass);
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz) {
        return BeanUtil.buildListFrom(src, clz, null, false);
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, boolean deeply) {
        return BeanUtil.buildListFrom(src, clz, null, deeply);
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties) {
        return BeanUtil.buildListFrom(src, clz, ignoreProperties, false);
    }

    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties, boolean deeply) {
        if (CollectionUtils.isEmpty(src)) {
            return new ArrayList();
        }
        ArrayList<T> objs = new ArrayList<T>(src.size());
        for (Object o : src) {
            T obj = BeanUtil.buildFroms(o, clz, ignoreProperties, deeply);
            objs.add(obj);
        }
        return objs;
    }

    private static <K, V> Map<K, V> newEmptyMap(Class srcClass) {
        if (ConcurrentReferenceHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentReferenceHashMap();
        }
        if (ConcurrentSkipListMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentSkipListMap();
        }
        if (ConcurrentHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentHashMap();
        }
        if (LinkedHashMap.class.isAssignableFrom(srcClass)) {
            return new LinkedHashMap();
        }
        return new HashMap();
    }

    public static <K, V> Map<K, V> buildMapFrom(Map<K, ?> src, Class<V> valueClass) {
        return BeanUtil.buildMapFrom(src, valueClass, null, false);
    }

    public static <K, V> Map<K, V> buildMapFrom(Map<K, ?> src, Class<V> valueClass, boolean deeply) {
        return BeanUtil.buildMapFrom(src, valueClass, null, deeply);
    }

    public static <K, V> Map<K, V> buildMapFrom(Map<K, ?> src, Class<V> valueClass, String[] ignoreProperties) {
        return BeanUtil.buildMapFrom(src, valueClass, ignoreProperties, false);
    }

    public static <K, V> Map<K, V> buildMapFrom(Map<K, ?> src, Class<V> valueClass, String[] ignoreProperties, boolean deeply) {
        if (MapUtils.isEmpty(src)) {
            return BeanUtil.newEmptyMap(src.getClass());
        }
        Map<K, V> resultMap = BeanUtil.newEmptyMap(src.getClass());
        for (Map.Entry<K, ?> entry : src.entrySet()) {
            K key = entry.getKey();
            Object value = entry.getValue();
            V newValue = BeanUtil.buildFroms(value, valueClass, ignoreProperties, deeply);
            resultMap.put(key, newValue);
        }
        return resultMap;
    }

    public static Map<String, Object> bean2Map(Object obj) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashSet<Field> fields = new HashSet<Field>();
        for (Class<?> clazz = obj.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        for (Field field : fields) {
            field.setAccessible(true);
            map.put(field.getName(), field.get(obj));
        }
        return map;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static String[] getEmptyPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (!EmptyUtil.isEmpty(srcValue)) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static void copyPropertiesIgnoreNull(Object src, Object target) {
        BeanUtils.copyProperties((Object)src, (Object)target, (String[])BeanUtil.getNullPropertyNames(src));
    }

    public static void copyPropertiesIgnoreEmpty(Object src, Object target) {
        BeanUtils.copyProperties((Object)src, (Object)target, (String[])BeanUtil.getEmptyPropertyNames(src));
    }

    static {
        primitiveSet.add(Boolean.class);
        primitiveSet.add(Character.class);
        primitiveSet.add(String.class);
        primitiveSet.add(Short.class);
        primitiveSet.add(Integer.class);
        primitiveSet.add(Long.class);
        primitiveSet.add(Float.class);
        primitiveSet.add(Double.class);
        primitiveSet.add(Void.class);
    }
}

