/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.converter;

import com.thebeastshop.common.converter.BeanConverter;
import com.thebeastshop.common.converter.BeanConverterHandlerManager;
import com.thebeastshop.common.converter.BeanFieldConverter;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.ToList;
import com.thebeastshop.common.enums.BooleanValue;
import com.thebeastshop.common.enums.CodeEnum;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GenericBeanConverter
implements BeanConverter {
    @Override
    public <T> ToList<T> from(Class<T> source) {
        return ConverterSupport.from(source);
    }

    protected static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }

    @Override
    public <T> T converterFrom(Object obj, Class<T> clazz) {
        if (obj == null) {
            return null;
        }
        Object ret = null;
        try {
            ret = clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class<?> fromClass = obj.getClass();
        BeanConverterHandlerManager handlerManager = GenericBeanConverter.matchHandlerManager(fromClass, clazz);
        if (handlerManager != null) {
            String[] ignoreFields = handlerManager.getIgnoreFields();
            GenericBeanConverter.copyProperties(obj, ret, ignoreFields);
            handlerManager.afterCopyProperties(obj, ret);
        } else {
            BeanUtils.copyProperties((Object)obj, ret);
        }
        return (T)ret;
    }

    public static void copyProperties(Object source, Object target, String ... ignoreProperties) throws BeansException {
        GenericBeanConverter.copyProperties(source, target, null, ignoreProperties);
    }

    public static void copyProperties(Object source, Object target, Class<?> editable, String ... ignoreProperties) throws BeansException {
        GenericBeanConverter.copyProperties(source, target, editable, false, ignoreProperties);
    }

    public static void copyProperties(Object source, Object target, Class<?> editable, boolean deeply, String ... ignoreProperties) throws BeansException {
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        PropertyDescriptor[] targetPds = BeanUtils.getPropertyDescriptors(actualEditable);
        List<String> ignoreList = ignoreProperties != null ? Arrays.asList(ignoreProperties) : null;
        for (PropertyDescriptor targetPd : targetPds) {
            Method readMethod;
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || ignoreList != null && ignoreList.contains(targetPd.getName()) || (sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || (readMethod = sourcePd.getReadMethod()) == null) continue;
            Class<?> writeType = writeMethod.getParameterTypes()[0];
            Class<?> readType = readMethod.getReturnType();
            Type writeGenericType = writeMethod.getGenericParameterTypes()[0];
            Type readGenericType = readMethod.getGenericReturnType();
            if (!GenericBeanConverter.checkType(writeType, readType, deeply)) continue;
            try {
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                Object value = readMethod.invoke(source, new Object[0]);
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                Object convertedValue = BeanFieldConverter.convert(value, readGenericType, writeGenericType, deeply);
                writeMethod.invoke(target, convertedValue);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy property '" + targetPd.getName() + "' from source to target", ex);
            }
        }
    }

    public static boolean isPrimaryIntegerNumber(Class type) {
        return Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type);
    }

    public static boolean isIntegerNumber(Class type) {
        return GenericBeanConverter.isPrimaryIntegerNumber(type) || BigInteger.class.isAssignableFrom(type) || BigDecimal.class.isAssignableFrom(type);
    }

    public static boolean isPrimaryDecimalNumber(Class type) {
        return Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type);
    }

    public static boolean isDecimalNumber(Class type) {
        return GenericBeanConverter.isPrimaryDecimalNumber(type) || BigDecimal.class.isAssignableFrom(type);
    }

    private static boolean checkType(Class writeType, Class readType) {
        return GenericBeanConverter.checkType(writeType, readType, false);
    }

    private static boolean checkType(Class writeType, Class readType, boolean deeply) {
        if (ClassUtils.isAssignable((Class)writeType, (Class)readType)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(writeType) && Boolean.class.isAssignableFrom(readType)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(readType) && Boolean.class.isAssignableFrom(writeType)) {
            return true;
        }
        if (GenericBeanConverter.isIntegerNumber(writeType) && GenericBeanConverter.isIntegerNumber(readType)) {
            return true;
        }
        if (GenericBeanConverter.isIntegerNumber(readType) && GenericBeanConverter.isIntegerNumber(writeType)) {
            return true;
        }
        if (BooleanValue.class.isAssignableFrom(readType) || BooleanValue.class.isAssignableFrom(writeType)) {
            return true;
        }
        if (CodeEnum.class.isAssignableFrom(readType) || CodeEnum.class.isAssignableFrom(writeType)) {
            return true;
        }
        return Serializable.class.isAssignableFrom(readType) && Serializable.class.isAssignableFrom(writeType);
    }

    @Override
    public <T> List<T> converterListFrom(List list, Class<T> clazz) {
        ArrayList<T> results = new ArrayList<T>();
        for (Object obj : list) {
            results.add(this.converterFrom(obj, clazz));
        }
        return results;
    }

    public GenericBeanConverter() {
        this.init();
    }

    protected void init() {
    }
}

