/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Lists;
import com.thebeastshop.common.converter.GenericBeanConverter;
import com.thebeastshop.common.enums.BooleanValue;
import com.thebeastshop.common.enums.CodeEnum;
import com.thebeastshop.common.exception.CodeEnumConvertException;
import com.thebeastshop.common.utils.BeanUtil;
import com.thebeastshop.common.utils.EnumUtil;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BeanFieldConverter {
    public static Object convert(Object sourceObj, Class sourceType, Class targetType) {
        return BeanFieldConverter.convert(sourceObj, sourceType, targetType, false);
    }

    public static Class<?> toClass(Type genericType) {
        if (genericType instanceof TypeReference) {
            return BeanFieldConverter.toClass(((TypeReference)genericType).getType());
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getRawType();
        }
        if (genericType instanceof TypeVariable) {
            TypeVariable tType = (TypeVariable)genericType;
            String className = tType.getGenericDeclaration().toString();
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
        if (genericType instanceof WildcardType && "?".equals(genericType.toString())) {
            return Object.class;
        }
        try {
            return (Class)genericType;
        }
        catch (Throwable th) {
            return Object.class;
        }
    }

    public static Object convert(Object sourceObj, Type sourceType, Type targetType, boolean deeply) {
        if (sourceObj == null) {
            return null;
        }
        Class<?> sourceClass = BeanFieldConverter.toClass(sourceType);
        Class<?> targetClass = BeanFieldConverter.toClass(targetType);
        if (targetClass.isAssignableFrom(sourceClass)) {
            return sourceObj;
        }
        if (GenericBeanConverter.isIntegerNumber(targetClass)) {
            if (Short.class.isAssignableFrom(targetClass) || Short.TYPE.isAssignableFrom(targetClass)) {
                if (sourceObj instanceof Byte) {
                    return ((Byte)sourceObj).shortValue();
                }
                if (sourceObj instanceof Short) {
                    return sourceObj;
                }
                if (sourceObj instanceof Integer) {
                    return ((Integer)sourceObj).shortValue();
                }
                if (sourceObj instanceof Long) {
                    return ((Long)sourceObj).shortValue();
                }
                if (sourceObj instanceof BigDecimal) {
                    return ((BigDecimal)sourceObj).shortValue();
                }
                if (sourceObj instanceof BigInteger) {
                    return ((BigInteger)sourceObj).shortValue();
                }
            }
            if (Integer.class.isAssignableFrom(targetClass) || Integer.TYPE.isAssignableFrom(targetClass)) {
                if (sourceObj instanceof Byte) {
                    return ((Byte)sourceObj).intValue();
                }
                if (sourceObj instanceof Short) {
                    return ((Short)sourceObj).intValue();
                }
                if (sourceObj instanceof Integer) {
                    return sourceObj;
                }
                if (sourceObj instanceof Long) {
                    return ((Long)sourceObj).intValue();
                }
                if (sourceObj instanceof BigDecimal) {
                    return ((BigDecimal)sourceObj).intValue();
                }
                if (sourceObj instanceof BigInteger) {
                    return ((BigInteger)sourceObj).intValue();
                }
            }
            if (Long.class.isAssignableFrom(targetClass) || Long.TYPE.isAssignableFrom(targetClass)) {
                if (sourceObj instanceof Byte) {
                    return ((Byte)sourceObj).longValue();
                }
                if (sourceObj instanceof Short) {
                    return ((Short)sourceObj).longValue();
                }
                if (sourceObj instanceof Integer) {
                    return ((Integer)sourceObj).longValue();
                }
                if (sourceObj instanceof Long) {
                    return sourceObj;
                }
                if (sourceObj instanceof BigDecimal) {
                    return ((BigDecimal)sourceObj).longValue();
                }
                if (sourceObj instanceof BigInteger) {
                    return ((BigInteger)sourceObj).longValue();
                }
            }
            if (BigInteger.class.isAssignableFrom(targetClass) && GenericBeanConverter.isIntegerNumber(sourceClass)) {
                return new BigInteger(sourceObj + "");
            }
            if (BigDecimal.class.isAssignableFrom(targetClass) && (GenericBeanConverter.isIntegerNumber(sourceClass) || GenericBeanConverter.isDecimalNumber(sourceClass))) {
                return new BigDecimal(sourceObj + "");
            }
            if (GenericBeanConverter.isPrimaryIntegerNumber(sourceClass)) {
                return targetClass.cast(sourceObj);
            }
        }
        if (GenericBeanConverter.isPrimaryDecimalNumber(targetClass)) {
            if (GenericBeanConverter.isPrimaryDecimalNumber(sourceClass)) {
                return targetClass.cast(sourceObj);
            }
            if ((Float.class.isAssignableFrom(targetClass) || Float.TYPE.isAssignableFrom(targetClass)) && sourceObj instanceof BigDecimal) {
                return Float.valueOf(((BigDecimal)sourceObj).floatValue());
            }
            if ((Double.class.isAssignableFrom(targetClass) || Double.TYPE.isAssignableFrom(targetClass)) && sourceObj instanceof BigDecimal) {
                return ((BigDecimal)sourceObj).doubleValue();
            }
        }
        if (Integer.class.isAssignableFrom(sourceClass) && Boolean.class.isAssignableFrom(targetClass)) {
            if ((Integer)sourceObj == 0) {
                return false;
            }
            return true;
        }
        if (Boolean.class.isAssignableFrom(sourceClass) && Integer.class.isAssignableFrom(targetClass)) {
            if (!((Boolean)sourceObj).booleanValue()) {
                return 0;
            }
            return 1;
        }
        if (sourceObj instanceof BooleanValue && (targetClass.isAssignableFrom(Boolean.class) || targetClass.isAssignableFrom(Boolean.TYPE))) {
            BooleanValue booleanValue = (BooleanValue)sourceObj;
            return booleanValue.toBooleanValue();
        }
        if (sourceObj instanceof CodeEnum) {
            CodeEnum codeEnum = (CodeEnum)sourceObj;
            Object code = codeEnum.getCode();
            Class<?> codeType = code.getClass();
            if (!targetClass.isAssignableFrom(codeType)) {
                throw new CodeEnumConvertException(sourceClass.getName() + "\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684\u6cdb\u578b\u7c7b\u578b\u53c2\u6570\uff0cCodeEnum<>\u6cdb\u578b\u53c2\u6570\u4e2d\u7684" + codeType.getName() + "\u4e0d\u80fd\u8f6c\u6362\u4e3a" + targetClass.getName());
            }
            return code;
        }
        if (Enum.class.isAssignableFrom(targetClass)) {
            if (BooleanValue.class.isAssignableFrom(targetClass) && (Boolean.class.isAssignableFrom(sourceClass) || Boolean.TYPE.isAssignableFrom(sourceClass))) {
                return EnumUtil.getByBooleanValue(targetClass, (Boolean)sourceObj);
            }
            if (CodeEnum.class.isAssignableFrom(targetClass)) {
                Type[] interfaces;
                for (Type type : interfaces = targetClass.getGenericInterfaces()) {
                    ParameterizedType parameterizedType;
                    Class rawType;
                    if (!(type instanceof ParameterizedType) || !CodeEnum.class.isAssignableFrom(rawType = (Class)(parameterizedType = (ParameterizedType)type).getRawType())) continue;
                    Type[] argTypes = parameterizedType.getActualTypeArguments();
                    if (argTypes.length != 1) {
                        throw new CodeEnumConvertException(targetClass.getName() + "\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684\u6cdb\u578b\u7c7b\u578b\u53c2\u6570");
                    }
                    Class argType = (Class)argTypes[0];
                    if (!argType.isAssignableFrom(sourceClass)) {
                        throw new CodeEnumConvertException(targetClass.getName() + "\u6ca1\u6709\u5305\u542b\u6b63\u786e\u7684\u6cdb\u578b\u7c7b\u578b\u53c2\u6570\uff0c " + sourceClass.getName() + "\u65e0\u6cd5\u8f6c\u6362\u4e3aCodeEnum<>\u6cdb\u578b\u53c2\u6570\u4e2d\u7684" + argType.getName());
                    }
                    return EnumUtil.getByCode(targetClass, sourceObj);
                }
            }
        }
        if (deeply) {
            if (targetType instanceof ParameterizedType && sourceType instanceof ParameterizedType) {
                ParameterizedType parameterizedTargetType = (ParameterizedType)targetType;
                ParameterizedType parameterizedSourceType = (ParameterizedType)sourceType;
                Class targetRawClass = (Class)parameterizedTargetType.getRawType();
                Class sourceRawClass = (Class)parameterizedSourceType.getRawType();
                if (Serializable.class.isAssignableFrom(targetRawClass) && Serializable.class.isAssignableFrom(sourceRawClass)) {
                    if (Collection.class.isAssignableFrom(sourceClass) && Collection.class.isAssignableFrom(targetClass)) {
                        return BeanUtil.buildListFrom((Collection)sourceObj, targetRawClass, deeply);
                    }
                    if (Map.class.isAssignableFrom(sourceClass) && Map.class.isAssignableFrom(targetClass)) {
                        return BeanUtil.buildMapFrom((Map)sourceObj, targetRawClass, deeply);
                    }
                }
            }
            if (Serializable.class.isAssignableFrom(sourceClass) && Serializable.class.isAssignableFrom(targetClass)) {
                return BeanUtil.buildFrom(sourceObj, targetClass, true);
            }
        }
        return null;
    }

    public static void main(String[] args) {
        int iiret = (Integer)BeanFieldConverter.convert(123, Integer.TYPE, Integer.TYPE);
        System.out.println("int to int -> " + iiret);
        int integeriret = (Integer)BeanFieldConverter.convert(123, Integer.class, Integer.TYPE);
        System.out.println("Integer to int -> " + integeriret);
        Integer iintegerret = (Integer)BeanFieldConverter.convert(123, Integer.TYPE, Integer.class);
        System.out.println("int to Integer -> " + iintegerret);
        BigDecimal idret = (BigDecimal)BeanFieldConverter.convert(123, Integer.class, BigDecimal.class);
        System.out.println("int to big decimal -> " + idret);
        BigDecimal ldret = (BigDecimal)BeanFieldConverter.convert(1230000L, Long.class, BigDecimal.class);
        System.out.println("long to big decimal -> " + ldret);
        Integer diret = (Integer)BeanFieldConverter.convert(new BigDecimal("234"), BigDecimal.class, Integer.class);
        System.out.println("big decimal to int -> " + diret);
        Long dlret = (Long)BeanFieldConverter.convert(new BigDecimal("2340000"), BigDecimal.class, Long.class);
        System.out.println("big decimal to long -> " + dlret);
        Long ilret = (Long)BeanFieldConverter.convert(200, Integer.class, Long.class);
        System.out.println("int to long -> " + ilret);
        Integer liret = (Integer)BeanFieldConverter.convert(20000L, Long.class, Integer.class);
        System.out.println("long to int -> " + liret);
        SrcUser srcUser1 = new SrcUser();
        srcUser1.setUsername("xxx");
        srcUser1.setPassword("yyy");
        SrcGood good1 = new SrcGood();
        good1.setName("Good1");
        good1.setPrice(14.5f);
        SrcGood good2 = new SrcGood();
        good2.setName("Good1");
        good2.setPrice(14.5f);
        srcUser1.setGoods(Lists.newArrayList((Object[])new SrcGood[]{good1, good2}));
        SrcUser srcUser2 = new SrcUser();
        srcUser2.setUsername("foo");
        srcUser2.setPassword("bar");
        ArrayList users = Lists.newArrayList((Object[])new SrcUser[]{srcUser1, srcUser2});
        List<TargetUser> targetUsers = BeanUtil.buildListFrom(users, TargetUser.class, false);
        System.out.println(JSON.toJSONString(targetUsers));
    }

    public static class TargetUser
    implements Serializable {
        private String username;
        private String password;
        private List<TargetGood> goods;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public List<TargetGood> getGoods() {
            return this.goods;
        }

        public void setGoods(List<TargetGood> goods) {
            this.goods = goods;
        }
    }

    public static class TargetGood
    implements Serializable {
        private String name;
        private float price;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public float getPrice() {
            return this.price;
        }

        public void setPrice(float price) {
            this.price = price;
        }
    }

    public static class SrcUser
    implements Serializable {
        private String username;
        private String password;
        private List<SrcGood> goods;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public List<SrcGood> getGoods() {
            return this.goods;
        }

        public void setGoods(List<SrcGood> goods) {
            this.goods = goods;
        }
    }

    public static class SrcGood
    implements Serializable {
        private String name;
        private float price;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public float getPrice() {
            return this.price;
        }

        public void setPrice(float price) {
            this.price = price;
        }
    }
}

