package com.thebeastshop.common;

import java.util.List;

public class PageQueryResp<T> extends BaseDO {
	private static final long serialVersionUID = 1L;

	private List<T> beanList;
	/**
	 * 总数
	 */
	private Integer totalCnt = 0;
	/**
	 * 第几页
	 */
	private Integer pageNo = 1;
	/**
	 * 起始数
	 */
	private Integer offset = 0;
	/**
	 * 每页数量
	 */
	private Integer pageSize = 20;

	public PageQueryResp() {
		super();
	}

	public PageQueryResp(List<T> beanList) {
		this.beanList = beanList;
	}

	public List<T> getBeanList() {
		return beanList;
	}

	public void setBeanList(List<T> beanList) {
		this.beanList = beanList;
	}

	public Integer getTotalCnt() {
		return totalCnt;
	}

	public void setTotalCnt(Integer totalCnt) {
		this.totalCnt = totalCnt;
	}

	public Integer getPageNo() {
		return pageNo;
	}

	public void setPageNo(Integer pageNo) {
		this.pageNo = pageNo;
		this.offset = (pageNo - 1) * pageSize;
	}

	public Integer getOffset() {
		return offset;
	}

	public void setOffset(Integer offset) {
		this.offset = offset;
		this.pageNo = offset / pageSize + 1;
		if (offset % pageSize > 0) {
			pageNo++;
		}
	}

	public Integer getPageSize() {
		return pageSize;
	}

	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

}
