/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.aop;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.dianping.cat.Cat;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.common.exception.BusinessException;
import com.thebeastshop.common.log.AopLogger;
import com.thebeastshop.common.spring.SpringAware;
import com.thebeastshop.common.utils.GZIPHelper;
import com.thebeastshop.common.utils.MetaUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;

@Aspect
public class ServiceAspect
implements InitializingBean {
    private final AopLogger log = new AopLogger(ServiceAspect.class);
    private int argLength;
    private boolean needCompress;
    private Environment environment = SpringAware.getBean(Environment.class);

    @Pointcut(value="@within(org.springframework.stereotype.Service) && within(com.thebeastshop..*)")
    public void cut() {
    }

    public void afterPropertiesSet() throws Exception {
        String argLengthStr = this.environment.getProperty("serviceAspect.argLength", "200");
        this.argLength = Integer.parseInt(argLengthStr);
        String needCompressStr = this.environment.getProperty("serviceAspect.needCompress", "false");
        this.needCompress = Boolean.parseBoolean(needCompressStr);
    }

    @Around(value="cut()")
    public Object around(ProceedingJoinPoint pJoinPoint) {
        try {
            Class<?> clazz = pJoinPoint.getTarget().getClass();
            String className = clazz.getSimpleName();
            Signature signature = pJoinPoint.getSignature();
            MethodSignature methodSignature = (MethodSignature)signature;
            Method method = methodSignature.getMethod();
            String methodName = method.getName();
            this.log.info("\u65b9\u6cd5[{}.{}]\u5f00\u59cb\u8c03\u7528", className, methodName);
            Object arg = null;
            StringBuilder argsBuilder = new StringBuilder("(");
            int argsLen = pJoinPoint.getArgs().length;
            try {
                for (int i = 0; i < argsLen; ++i) {
                    arg = pJoinPoint.getArgs()[i];
                    int argIndex = i + 1;
                    String argValue = this.getArgValue(arg);
                    argsBuilder.append("\u53c2\u6570" + argIndex + ": " + argValue);
                    if (i < argsLen - 1) {
                        argsBuilder.append(", ");
                    }
                    this.log.info("\u65b9\u6cd5[{}.{}]\u53c2\u6570{}:{}", className, methodName, argIndex, argValue);
                }
                argsBuilder.append(")");
                Cat.logEvent((String)"PigeonService.args", (String)(className + "." + methodName), (String)"0", (String)argsBuilder.toString());
            }
            catch (Exception e) {
                this.log.error("" + e);
            }
            long start = System.currentTimeMillis();
            ServiceResp result = null;
            try {
                result = pJoinPoint.proceed();
            }
            catch (Throwable t) {
                if (t instanceof BusinessException) {
                    this.log.info(t.getMessage());
                } else {
                    this.log.error("\u7cfb\u7edf\u53d1\u751f\u5f02\u5e38: ", t);
                }
                Class<?> retType = method.getReturnType();
                if (ServiceResp.class.isAssignableFrom(retType)) {
                    result = ServiceResp.newInstanceFail(t);
                    try {
                        SpringAware.rollBack();
                    }
                    catch (Throwable throwable) {}
                }
                throw t;
            }
            if (result != null && result instanceof ServiceResp) {
                ServiceResp resp = result;
                resp.setAppId(MetaUtil.APP_NAME);
            }
            long end = System.currentTimeMillis();
            this.log.info("\u65b9\u6cd5[{}.{}]\u7ed3\u675f\u8c03\u7528,\u603b\u5171\u8017\u65f6{}\u6beb\u79d2", className, methodName, end - start);
            return result;
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
    }

    private String getArgValue(Object arg) {
        String argValue;
        if (arg == null) {
            return "null";
        }
        if (arg instanceof CharSequence) {
            return "\"" + arg.toString() + "\"";
        }
        if (Integer.TYPE.isAssignableFrom(arg.getClass()) || Long.TYPE.isAssignableFrom(arg.getClass()) || Short.TYPE.isAssignableFrom(arg.getClass()) || Byte.TYPE.isAssignableFrom(arg.getClass()) || Boolean.TYPE.isAssignableFrom(arg.getClass())) {
            return String.valueOf(arg);
        }
        try {
            argValue = JSON.toJSONString((Object)arg, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
            if (this.argLength == -1 && this.needCompress) {
                argValue = GZIPHelper.zipAndSerialize(argValue);
            } else if (this.argLength != -1 && argValue.length() > this.argLength) {
                argValue = argValue.substring(0, this.argLength) + " ...";
            }
        }
        catch (Exception ex) {
            try {
                argValue = arg.getClass().getSimpleName() + " " + String.valueOf(arg);
            }
            catch (Exception ex2) {
                argValue = "null";
            }
        }
        return argValue;
    }

    public int getArgLength() {
        return this.argLength;
    }

    public void setArgLength(int argLength) {
        this.argLength = argLength;
    }

    public boolean isNeedCompress() {
        return this.needCompress;
    }

    public void setNeedCompress(boolean needCompress) {
        this.needCompress = needCompress;
    }
}

