/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class Pagination<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer maxPages = 0;
    private Integer currpage = 1;
    private Integer pagenum = 0;
    private Integer record;
    private Integer currPageFirstSerNo = 1;
    private List<E> resultList;
    private Object extendProperty;
    public static final Integer DEFAULT_SIZE = 10;

    public Pagination() {
    }

    public Pagination(Integer page, Integer size) {
        this.currpage = page;
        this.pagenum = size;
    }

    public Pagination(Integer maxPages, Integer currpage, Integer pagenum, Integer record) {
        this.maxPages = maxPages;
        this.currpage = currpage;
        this.pagenum = pagenum;
        this.record = record;
    }

    public Integer getMaxPages() {
        float nrOfPages = (float)this.getRecord().intValue() / (float)this.getPagenum().intValue();
        this.maxPages = (int)(nrOfPages > (float)((int)nrOfPages) || (double)nrOfPages == 0.0 ? nrOfPages + 1.0f : nrOfPages);
        return this.maxPages;
    }

    public Integer getCurrpage() {
        return this.currpage;
    }

    public void setCurrpage(Integer currpage) {
        this.currpage = currpage;
    }

    public Integer getPagenum() {
        if (this.pagenum == null) {
            return 1;
        }
        return this.pagenum;
    }

    public void setPagenum(Integer pagenum) {
        this.pagenum = pagenum;
    }

    public Integer getRecord() {
        this.record = this.record == null || this.record < 0 ? 0 : this.record;
        return this.record;
    }

    public List<E> getResultList() {
        if (this.resultList == null) {
            this.resultList = Collections.emptyList();
        }
        return this.resultList;
    }

    public List<E> getResultListClone() {
        if (this.resultList == null) {
            this.resultList = Collections.emptyList();
        }
        return Collections.unmodifiableList(this.resultList);
    }

    public void add(E e) {
        this.resultList.add(e);
    }

    public boolean remove(E e) {
        if (e != null) {
            return this.resultList.remove(e);
        }
        return false;
    }

    public void setResultList(List<E> resultList) {
        this.resultList = resultList;
    }

    public void setRecord(Integer record) {
        this.record = record;
    }

    public Object getCurrPageFirstSerNo() {
        if (null == this.getPagenum()) {
            this.setPagenum(1);
        }
        if (null == this.getCurrpage()) {
            this.setCurrpage(0);
        }
        int firstSerNo = (this.getCurrpage() == 0 ? 0 : this.getCurrpage() - 1) * this.getPagenum() + 1;
        this.currPageFirstSerNo = firstSerNo;
        return this.currPageFirstSerNo;
    }

    public Object getExtendProperty() {
        return this.extendProperty;
    }

    public void setExtendProperty(Object extendProperty) {
        this.extendProperty = extendProperty;
    }

    public void setCurrPageFirstSerNo(Integer currPageFirstSerNo) {
        this.currPageFirstSerNo = currPageFirstSerNo;
    }
}

