package com.thebeastshop.common.converter;

import java.util.List;

/**
 * @author gongjun[jun.gong@thebeastshop.com]
 * @since 2017-04-25 17:01
 */
public class GenericPOVOConverter<VO, PO> extends GenericBeanConverter implements POVOConverter<VO, PO> {

    protected final Class<VO> voClass;

    protected final Class<PO> poClass;

    public GenericPOVOConverter(Class<VO> voClass, Class<PO> poClass) {
        this.voClass = voClass;
        this.poClass = poClass;
    }

    @Override
    public Class<VO> getVOClass() {
        return voClass;
    }

    @Override
    public Class<PO> getPOClass() {
        return poClass;
    }

    @Override
    public VO voFromPO(PO po) {
        return converterFrom(po, voClass);
    }

    @Override
    public PO poFromVO(VO vo) {
        return converterFrom(vo, poClass);
    }

    @Override
    public VO voFromObject(Object obj) {
        return converterFrom(obj, voClass);
    }

    @Override
    public PO poFromObject(Object obj) {
        return converterFrom(obj, poClass);
    }

    @Override
    public List<VO> voListFromPOList(List<PO> pos) {
        return converterListFrom(pos, voClass);
    }

    @Override
    public List<PO> poListFromVOList(List<VO> vos) {
        return converterListFrom(vos, poClass);
    }

    @Override
    public List<VO> voListFromList(List<?> list) {
        return converterListFrom(list, voClass);
    }

    @Override
    public List<PO> poListFromList(List<?> list) {
        return converterListFrom(list, poClass);
    }

}
