/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.exception;

import com.thebeastshop.common.exception.BaseErrorCode;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class BaseServiceException
extends RuntimeException {
    private String errorCode;

    public BaseServiceException(String errorCode) {
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, Throwable cause) {
        this(errorCode, null, cause);
        this.errorCode = errorCode;
    }

    public BaseServiceException(BaseErrorCode exceptionCode, Throwable cause) {
        this(exceptionCode, exceptionCode.getErrorCode(), cause);
    }

    public BaseServiceException(BaseErrorCode exceptionCode) {
        this(exceptionCode.getErrorCode(), exceptionCode.getMessage());
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg) {
        this(exceptionCode.getErrorCode(), msg);
    }

    public BaseServiceException(BaseErrorCode exceptionCode, String msg, Throwable cause) {
        this(exceptionCode.getErrorCode(), msg, cause);
    }

    public BaseServiceException(String errorCode, String msg) {
        super(msg);
        this.errorCode = errorCode;
    }

    public BaseServiceException(String errorCode, String msg, Throwable cause) {
        super("[" + BaseServiceException.getAppId() + ":" + errorCode + "]" + msg, cause);
        this.errorCode = errorCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public static String getAppId() {
        String str = System.getProperty("user.dir");
        if (StringUtils.isBlank((CharSequence)str)) {
            return "[empty]";
        }
        String appId = str.substring(str.lastIndexOf(File.separator) + 1);
        return appId;
    }

    public Map<String, Object> getErrorData() {
        return new HashMap<String, Object>();
    }
}

