/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.common.converter;

import com.thebeastshop.common.converter.BaseDomain;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.GenericPOVOConverter;
import com.thebeastshop.common.converter.POVOConverter;
import com.thebeastshop.common.converter.ToList;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseDomain<VO, PO>
implements BaseDomain<VO, PO> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected POVOConverter<VO, PO> converter;

    @Override
    public Class<VO> getVOClass() {
        return this.converter.getVOClass();
    }

    @Override
    public Class<PO> getPOClass() {
        return this.converter.getPOClass();
    }

    @Override
    public <T> ToList<T> from(Class<T> source) {
        return ConverterSupport.from(source);
    }

    public AbstractBaseDomain() {
        this.initConverter();
        this.init();
    }

    protected <T> Class<T> getGenericClass(int index) {
        Type superClass = this.getClass().getGenericSuperclass();
        Type[] types = ((ParameterizedType)superClass).getActualTypeArguments();
        if (types.length - 1 < index) {
            return null;
        }
        Type type = types[index];
        if (type instanceof TypeVariable) {
            return (Class)((TypeVariable)type).getBounds()[0];
        }
        return (Class)type;
    }

    private void initConverter() {
        this.converter = this.createConverter();
    }

    protected POVOConverter<VO, PO> createConverter() {
        Class voClass = this.getGenericClass(0);
        Class poClass = this.getGenericClass(1);
        return new GenericPOVOConverter(voClass, poClass);
    }

    protected void init() {
    }

    protected POVOConverter<VO, PO> getConverter() {
        return this.converter;
    }

    @Override
    public <T> T converterFrom(Object obj, Class<T> clazz) {
        return this.getConverter().converterFrom(obj, clazz);
    }

    @Override
    public <T> List<T> converterListFrom(List list, Class<T> clazz) {
        return this.getConverter().converterListFrom(list, clazz);
    }

    @Override
    public VO voFromPO(PO po) {
        return this.getConverter().voFromPO(po);
    }

    @Override
    public List<VO> voListFromPOList(List<PO> pos) {
        return this.getConverter().voListFromPOList(pos);
    }

    @Override
    public PO poFromVO(VO vo) {
        return this.getConverter().poFromVO(vo);
    }

    @Override
    public List<PO> poListFromVOList(List<VO> vos) {
        return this.getConverter().poListFromVOList(vos);
    }

    @Override
    public VO voFromObject(Object obj) {
        return this.getConverter().voFromObject(obj);
    }

    @Override
    public List<VO> voListFromList(List<?> list) {
        return this.getConverter().voListFromList(list);
    }

    @Override
    public PO poFromObject(Object obj) {
        return this.getConverter().poFromObject(obj);
    }

    @Override
    public List<PO> poListFromList(List<?> list) {
        return this.getConverter().poListFromList(list);
    }
}

