/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NumberUtil extends NumberUtils {

    /**
     * 判断是否为空，或者0
     *
     * @param number
     * @return
     */
    public static boolean isNullOrZero(Number number) {
        return number == null || number.intValue() == 0;
    }

    public static Number avoidNull(Number number) {
        return NumberUtil.avoidNull(number, 0);
    }

    public static Number avoidNull(Number number, Number defVal) {
        return number == null ? defVal : number;
    }

    public static List<Long> convertListFromString(List<String> codes) {
        if (CollectionUtils.isEmpty(codes)) return Collections.emptyList();
        List<Long> ids = new ArrayList<>(codes.size());
        for (String code : codes) {
            try {
                ids.add(Long.valueOf(code));
            } catch (Exception ex) {
            }
        }
        return ids;
    }

    public static List<String> convertStringFromNumber(List<Long> idList) {
        if (CollectionUtils.isEmpty(idList)) return Collections.emptyList();
        List<String> strList = new ArrayList<>(idList.size());
        for (Long id : idList) {
            strList.add(String.valueOf(id));
        }
        return strList;
    }

    private static boolean isMatch(String regex, String orginal) {
        if (orginal == null || orginal.trim().equals("")) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher isNum = pattern.matcher(orginal);
        return isNum.matches();
    }

    public static boolean isPositiveInteger(String orginal) {
        return isMatch("^\\+{0,1}[1-9]\\d*", orginal);
    }

    public static boolean isNegativeInteger(String orginal) {
        return isMatch("^-[1-9]\\d*", orginal);
    }

    public static boolean isWholeNumber(String orginal) {
        return isMatch("[+-]{0,1}0", orginal) || isPositiveInteger(orginal) || isNegativeInteger(orginal);
    }

    public static boolean isPositiveDecimal(String orginal) {
        return isMatch("\\+{0,1}[0]\\.[1-9]*|\\+{0,1}[1-9]\\d*\\.\\d*", orginal);
    }

    public static boolean isNegativeDecimal(String orginal) {
        return isMatch("^-[0]\\.[1-9]*|^-[1-9]\\d*\\.\\d*", orginal);
    }

    public static boolean isDecimal(String orginal) {
        return isMatch("[-+]{0,1}\\d+\\.\\d*|[-+]{0,1}\\d*\\.\\d+", orginal);
    }

    public static boolean isRealNumber(String orginal) {
        return isWholeNumber(orginal) || isDecimal(orginal);
    }

}
