/*
 * Copyright (C), 上海布鲁爱电子商务有限公司
 */
package com.thebeastshop.common.utils;

import com.thebeastshop.common.converter.BeanConverterHandlerManager;
import com.thebeastshop.common.converter.ConverterSupport;
import com.thebeastshop.common.converter.GenericBeanConverter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.ConcurrentReferenceHashMap;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;

/**
 * @author Roy.Chen
 * @version $Id: ReflectionUtil.java, v 0.1 2015-08-12 18:20
 */
public class BeanUtil {

    public static BeanConverterHandlerManager matchHandlerManager(Class<?> fromClass, Class<?> toClass) {
        return ConverterSupport.matchHandlerManager(fromClass, toClass);
    }


    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> T buildFrom(Object src, Class<T> clz) {
        return buildFrom(src, clz, null);
    }

    /**
     *
     * @param src  源bean
     * @param clazz   目标bean class
     * @param ignoreProperties 忽略的属性
     * @return
     */
    public static <T> T buildFrom(Object src, Class<T> clazz, String[] ignoreProperties) {
        if (src == null) {
            return null;
        }
        T ret = null;
        try {
            ret = clazz.newInstance();
        } catch (InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        if (ret == null) {
            return null;
        }
        Class fromClass = src.getClass();
        BeanConverterHandlerManager handlerManager = matchHandlerManager(fromClass, clazz);
        String[] ignoreFields = ignoreProperties;
        if (handlerManager != null) {
            if (ignoreFields == null) {
                ignoreFields = handlerManager.getIgnoreFields();
            }
            GenericBeanConverter.copyProperties(src, ret, ignoreFields);
            handlerManager.afterCopyProperties(src, ret);
        }
        else {
            GenericBeanConverter.copyProperties(src, ret, ignoreFields);
        }
        return ret;
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @return
     */
    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz) {
        return buildListFrom(src, clz, null);
    }

    /**
     *
     * @param src  源bean
     * @param clz   目标bean class
     * @param ignoreProperties 忽略的属性
     * @return
     */
    public static <T> List<T> buildListFrom(Collection<?> src, Class<T> clz, String[] ignoreProperties) {
        if (CollectionUtils.isEmpty(src))
            return Collections.emptyList();

        List<T> objs = new ArrayList<T>(src.size());
        for (Object o : src) {
            T obj = buildFrom(o, clz, ignoreProperties);
            objs.add(obj);
        }
        return objs;
    }


    private static <K, V> Map<K, V> newEmptyMap(Class srcClass) {
        if (ConcurrentReferenceHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentReferenceHashMap<>();
        }
        if (ConcurrentSkipListMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentSkipListMap<>();
        }
        if (ConcurrentHashMap.class.isAssignableFrom(srcClass)) {
            return new ConcurrentHashMap<>();
        }
        if (LinkedHashMap.class.isAssignableFrom(srcClass)) {
            return new LinkedHashMap<>();
        }
        return new HashMap<>();
    }


    public static <K, V> Map<K, V> buildMapFrom(
            Map<K, ?> src,
            Class<V> valueClass) {
        return buildMapFrom(src, valueClass, null);
    }


    public static <K, V> Map<K, V> buildMapFrom(
            Map<K, ?> src,
            Class<V> valueClass,
            String[] ignoreProperties) {
        if (MapUtils.isEmpty(src)) {
            return newEmptyMap(src.getClass());
        }
        Map<K, V> resultMap = newEmptyMap(src.getClass());
        for (Map.Entry<K, ?> entry : src.entrySet()) {
            K key = entry.getKey();
            Object value = entry.getValue();
            V newValue = buildFrom(value, valueClass, ignoreProperties);
            resultMap.put(key, newValue);
        }
        return resultMap;
    }

	/**
	 * 获取空值的字段名
	 *
	 * @param source
	 * @return
	 */
	public static String[] getNullPropertyNames(Object source) {
		final BeanWrapper src = new BeanWrapperImpl(source);
		java.beans.PropertyDescriptor[] pds = src.getPropertyDescriptors();

		Set<String> emptyNames = new HashSet<String>();
		for (java.beans.PropertyDescriptor pd : pds) {
			Object srcValue = src.getPropertyValue(pd.getName());
			if (srcValue == null)
				emptyNames.add(pd.getName());
		}
		String[] result = new String[emptyNames.size()];
		return emptyNames.toArray(result);
	}

	/**
	 * 覆盖字段值（排除空值）
	 *
	 * @param src
	 * @param target
	 */
	public static void copyPropertiesIgnoreNull(Object src, Object target) {
		BeanUtils.copyProperties(src, target, getNullPropertyNames(src));
	}
}
